/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.automl.hyperparameter;

import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.ml.models.automl.hyperparameter.ImmutableDoubleRangeParameter;
import org.neo4j.gds.ml.models.automl.hyperparameter.NumericalRangeParameter;

@ValueClass
public interface DoubleRangeParameter
extends NumericalRangeParameter<Double> {
    public boolean logScale();

    public static DoubleRangeParameter of(double min, double max) {
        return DoubleRangeParameter.of(min, max, false);
    }

    public static DoubleRangeParameter of(double min, double max, boolean logScale) {
        return ImmutableDoubleRangeParameter.of((Double)min, (Double)max, logScale);
    }

    @Override
    @Value.Derived
    default public Map<String, Object> toMap() {
        return Map.of("range", List.of((Double)this.min(), (Double)this.max()));
    }
}

