/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.automl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.ml.models.automl.ImmutableRangeParameters;
import org.neo4j.gds.ml.models.automl.TunableTrainerConfig;
import org.neo4j.gds.ml.models.automl.hyperparameter.ConcreteParameter;
import org.neo4j.gds.ml.models.automl.hyperparameter.DoubleParameter;
import org.neo4j.gds.ml.models.automl.hyperparameter.DoubleRangeParameter;
import org.neo4j.gds.ml.models.automl.hyperparameter.IntegerParameter;
import org.neo4j.gds.ml.models.automl.hyperparameter.IntegerRangeParameter;
import org.neo4j.gds.ml.models.automl.hyperparameter.ListParameter;
import org.neo4j.gds.ml.models.automl.hyperparameter.StringParameter;
import org.neo4j.gds.utils.StringFormatting;

final class ParameterParser {
    private ParameterParser() {
    }

    static RangeParameters parseRangeParameters(Map<String, Object> input) {
        HashMap doubleRanges = new HashMap();
        HashMap integerRanges = new HashMap();
        LinkedHashMap incorrectParameters = new LinkedHashMap();
        LinkedHashMap incorrectMaps = new LinkedHashMap();
        input.forEach((key, value) -> {
            if (value instanceof Map) {
                if (TunableTrainerConfig.NON_NUMERIC_PARAMETERS.containsKey(key)) {
                    incorrectParameters.put(key, value);
                    return;
                }
                if (!((Map)value).keySet().equals(Set.of("range"))) {
                    incorrectMaps.put(key, value);
                    return;
                }
                if (!(((Map)value).get("range") instanceof List)) {
                    incorrectMaps.put(key, value);
                    return;
                }
                List range = (List)((Map)value).get("range");
                if (range.size() != 2) {
                    incorrectMaps.put(key, value);
                    return;
                }
                Object minObject = range.get(0);
                Object maxObject = range.get(1);
                if (!ParameterParser.typeIsSupportedInRange(minObject) || !ParameterParser.typeIsSupportedInRange(maxObject)) {
                    incorrectMaps.put(key, value);
                    return;
                }
                Number min = (Number)minObject;
                Number max = (Number)maxObject;
                if (ParameterParser.isFloatOrDouble(min) || ParameterParser.isFloatOrDouble(max)) {
                    boolean logScale = TunableTrainerConfig.LOG_SCALE_PARAMETERS.contains(key);
                    doubleRanges.put(key, DoubleRangeParameter.of(min.doubleValue(), max.doubleValue(), logScale));
                    return;
                }
                integerRanges.put(key, IntegerRangeParameter.of(min.intValue(), max.intValue()));
            }
        });
        if (!incorrectParameters.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The following parameters have been given the wrong type: [%s]", (Object[])new Object[]{incorrectParameters.entrySet().stream().map(s -> "`" + s + "` (`" + (String)s.getKey() + "` is of type " + TunableTrainerConfig.NON_NUMERIC_PARAMETERS.get(s.getKey()).getSimpleName() + ")").collect(Collectors.joining(", "))}));
        }
        if (!incorrectMaps.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Ranges for training hyper-parameters must be of the form {range: {min, max}}, where both min and max are numerical. Invalid parameters: [%s]", (Object[])new Object[]{incorrectMaps.entrySet().stream().map(s -> "`" + s + "`").collect(Collectors.joining(", "))}));
        }
        return ImmutableRangeParameters.of(Map.copyOf(doubleRanges), Map.copyOf(integerRanges));
    }

    private static boolean typeIsSupportedInRange(Object value) {
        return value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Long;
    }

    private static boolean isFloatOrDouble(Object value) {
        return value instanceof Double || value instanceof Float;
    }

    static Map<String, ConcreteParameter<?>> parseConcreteParameters(Map<String, Object> input) {
        return input.entrySet().stream().filter(entry -> !(entry.getValue() instanceof Map)).collect(Collectors.toMap(Map.Entry::getKey, entry -> ParameterParser.parseConcreteParameter((String)entry.getKey(), entry.getValue())));
    }

    private static ConcreteParameter<?> parseConcreteParameter(String key, Object value) {
        if (TunableTrainerConfig.NON_NUMERIC_PARAMETERS.containsKey(key)) {
            return ParameterParser.parseConcreteNonNumericParameter(key, value);
        }
        return ParameterParser.parseConcreteNumericParameter(key, value);
    }

    private static ConcreteParameter<?> parseConcreteNonNumericParameter(String key, Object value) {
        Class correctParameterType = TunableTrainerConfig.NON_NUMERIC_PARAMETERS.get(key);
        if (!correctParameterType.isInstance(value)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Parameter `%s` must be of the type `%s`.", (Object[])new Object[]{key, correctParameterType.getSimpleName()}));
        }
        if (correctParameterType == String.class) {
            return StringParameter.of((String)value);
        }
        if (correctParameterType == List.class) {
            if (key.equals("hiddenLayerSizes")) {
                List intValues = ((List)value).stream().map(Number::intValue).collect(Collectors.toList());
                return ListParameter.of(intValues);
            }
            if (key.equals("classWeights")) {
                List doubleValues = ((List)value).stream().map(Number::doubleValue).collect(Collectors.toList());
                return ListParameter.of(doubleValues);
            }
        }
        throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Was not able to resolve type of parameter `%s`.", (Object[])new Object[]{key}));
    }

    private static ConcreteParameter<?> parseConcreteNumericParameter(String key, Object value) {
        if (value instanceof Integer) {
            return IntegerParameter.of((Integer)value);
        }
        if (value instanceof Long) {
            return IntegerParameter.of(Math.toIntExact((Long)value));
        }
        if (value instanceof Double) {
            return DoubleParameter.of((Double)value);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Parameter `%s` must be numeric or a map of the form {range: [min, max]}.", (Object[])new Object[]{key}));
    }

    @ValueClass
    static interface RangeParameters {
        public Map<String, DoubleRangeParameter> doubleRanges();

        public Map<String, IntegerRangeParameter> integerRanges();
    }
}

