/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models.automl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.models.automl.ParameterParser;
import org.neo4j.gds.ml.models.automl.hyperparameter.DoubleRangeParameter;
import org.neo4j.gds.ml.models.automl.hyperparameter.IntegerRangeParameter;

@Generated(from="ParameterParser.RangeParameters", generator="Immutables")
public final class ImmutableRangeParameters
implements ParameterParser.RangeParameters {
    private final Map<String, DoubleRangeParameter> doubleRanges;
    private final Map<String, IntegerRangeParameter> integerRanges;

    private ImmutableRangeParameters(Map<String, ? extends DoubleRangeParameter> doubleRanges, Map<String, ? extends IntegerRangeParameter> integerRanges) {
        this.doubleRanges = ImmutableRangeParameters.createUnmodifiableMap(true, false, doubleRanges);
        this.integerRanges = ImmutableRangeParameters.createUnmodifiableMap(true, false, integerRanges);
    }

    private ImmutableRangeParameters(ImmutableRangeParameters original, Map<String, DoubleRangeParameter> doubleRanges, Map<String, IntegerRangeParameter> integerRanges) {
        this.doubleRanges = doubleRanges;
        this.integerRanges = integerRanges;
    }

    @Override
    public Map<String, DoubleRangeParameter> doubleRanges() {
        return this.doubleRanges;
    }

    @Override
    public Map<String, IntegerRangeParameter> integerRanges() {
        return this.integerRanges;
    }

    public final ImmutableRangeParameters withDoubleRanges(Map<String, ? extends DoubleRangeParameter> entries) {
        if (this.doubleRanges == entries) {
            return this;
        }
        Map<String, DoubleRangeParameter> newValue = ImmutableRangeParameters.createUnmodifiableMap(true, false, entries);
        return new ImmutableRangeParameters(this, newValue, this.integerRanges);
    }

    public final ImmutableRangeParameters withIntegerRanges(Map<String, ? extends IntegerRangeParameter> entries) {
        if (this.integerRanges == entries) {
            return this;
        }
        Map<String, IntegerRangeParameter> newValue = ImmutableRangeParameters.createUnmodifiableMap(true, false, entries);
        return new ImmutableRangeParameters(this, this.doubleRanges, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRangeParameters && this.equalTo(0, (ImmutableRangeParameters)another);
    }

    private boolean equalTo(int synthetic, ImmutableRangeParameters another) {
        return this.doubleRanges.equals(another.doubleRanges) && this.integerRanges.equals(another.integerRanges);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.doubleRanges.hashCode();
        h += (h << 5) + this.integerRanges.hashCode();
        return h;
    }

    public String toString() {
        return "RangeParameters{doubleRanges=" + this.doubleRanges + ", integerRanges=" + this.integerRanges + "}";
    }

    public static ParameterParser.RangeParameters of(Map<String, ? extends DoubleRangeParameter> doubleRanges, Map<String, ? extends IntegerRangeParameter> integerRanges) {
        return new ImmutableRangeParameters(doubleRanges, integerRanges);
    }

    static ParameterParser.RangeParameters copyOf(ParameterParser.RangeParameters instance) {
        if (instance instanceof ImmutableRangeParameters) {
            return (ImmutableRangeParameters)instance;
        }
        return ImmutableRangeParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ParameterParser.RangeParameters", generator="Immutables")
    static final class Builder {
        private Map<String, DoubleRangeParameter> doubleRanges = null;
        private Map<String, IntegerRangeParameter> integerRanges = null;

        private Builder() {
        }

        public final Builder from(ImmutableRangeParameters instance) {
            return this.from((ParameterParser.RangeParameters)instance);
        }

        final Builder from(ParameterParser.RangeParameters instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllDoubleRanges(instance.doubleRanges());
            this.putAllIntegerRanges(instance.integerRanges());
            return this;
        }

        public final Builder putDoubleRange(String key, DoubleRangeParameter value) {
            if (this.doubleRanges == null) {
                this.doubleRanges = new LinkedHashMap<String, DoubleRangeParameter>();
            }
            this.doubleRanges.put(Objects.requireNonNull(key, "doubleRanges key"), Objects.requireNonNull(value, value == null ? "doubleRanges value for key: " + key : null));
            return this;
        }

        public final Builder putDoubleRange(Map.Entry<String, ? extends DoubleRangeParameter> entry) {
            DoubleRangeParameter v;
            if (this.doubleRanges == null) {
                this.doubleRanges = new LinkedHashMap<String, DoubleRangeParameter>();
            }
            String k = entry.getKey();
            this.doubleRanges.put(Objects.requireNonNull(k, "doubleRanges key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "doubleRanges value for key: " + k : null));
            return this;
        }

        public final Builder doubleRanges(Map<String, ? extends DoubleRangeParameter> entries) {
            this.doubleRanges = new LinkedHashMap<String, DoubleRangeParameter>();
            return this.putAllDoubleRanges(entries);
        }

        public final Builder putAllDoubleRanges(Map<String, ? extends DoubleRangeParameter> entries) {
            if (this.doubleRanges == null) {
                this.doubleRanges = new LinkedHashMap<String, DoubleRangeParameter>();
            }
            for (Map.Entry<String, ? extends DoubleRangeParameter> e : entries.entrySet()) {
                DoubleRangeParameter v;
                String k = e.getKey();
                this.doubleRanges.put(Objects.requireNonNull(k, "doubleRanges key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "doubleRanges value for key: " + k : null));
            }
            return this;
        }

        public final Builder putIntegerRange(String key, IntegerRangeParameter value) {
            if (this.integerRanges == null) {
                this.integerRanges = new LinkedHashMap<String, IntegerRangeParameter>();
            }
            this.integerRanges.put(Objects.requireNonNull(key, "integerRanges key"), Objects.requireNonNull(value, value == null ? "integerRanges value for key: " + key : null));
            return this;
        }

        public final Builder putIntegerRange(Map.Entry<String, ? extends IntegerRangeParameter> entry) {
            IntegerRangeParameter v;
            if (this.integerRanges == null) {
                this.integerRanges = new LinkedHashMap<String, IntegerRangeParameter>();
            }
            String k = entry.getKey();
            this.integerRanges.put(Objects.requireNonNull(k, "integerRanges key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "integerRanges value for key: " + k : null));
            return this;
        }

        public final Builder integerRanges(Map<String, ? extends IntegerRangeParameter> entries) {
            this.integerRanges = new LinkedHashMap<String, IntegerRangeParameter>();
            return this.putAllIntegerRanges(entries);
        }

        public final Builder putAllIntegerRanges(Map<String, ? extends IntegerRangeParameter> entries) {
            if (this.integerRanges == null) {
                this.integerRanges = new LinkedHashMap<String, IntegerRangeParameter>();
            }
            for (Map.Entry<String, ? extends IntegerRangeParameter> e : entries.entrySet()) {
                IntegerRangeParameter v;
                String k = e.getKey();
                this.integerRanges.put(Objects.requireNonNull(k, "integerRanges key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "integerRanges value for key: " + k : null));
            }
            return this;
        }

        public Builder clear() {
            if (this.doubleRanges != null) {
                this.doubleRanges.clear();
            }
            if (this.integerRanges != null) {
                this.integerRanges.clear();
            }
            return this;
        }

        public ParameterParser.RangeParameters build() {
            return new ImmutableRangeParameters(null, this.doubleRanges == null ? Collections.emptyMap() : ImmutableRangeParameters.createUnmodifiableMap(false, false, this.doubleRanges), this.integerRanges == null ? Collections.emptyMap() : ImmutableRangeParameters.createUnmodifiableMap(false, false, this.integerRanges));
        }
    }
}

