/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models;

import java.util.Optional;
import org.neo4j.gds.core.utils.progress.tasks.LogLevel;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.models.RegressorTrainer;
import org.neo4j.gds.ml.models.TrainerConfig;
import org.neo4j.gds.ml.models.linearregression.LinearRegressionTrainConfig;
import org.neo4j.gds.ml.models.linearregression.LinearRegressionTrainer;
import org.neo4j.gds.ml.models.randomforest.RandomForestRegressorTrainer;
import org.neo4j.gds.ml.models.randomforest.RandomForestRegressorTrainerConfig;
import org.neo4j.gds.termination.TerminationFlag;
import org.neo4j.gds.utils.StringFormatting;

public final class RegressionTrainerFactory {
    private RegressionTrainerFactory() {
    }

    public static RegressorTrainer create(TrainerConfig config, TerminationFlag terminationFlag, ProgressTracker progressTracker, LogLevel messageLogLevel, int concurrency, Optional<Long> randomSeed) {
        switch (config.method()) {
            case LinearRegression: {
                return new LinearRegressionTrainer(concurrency, (LinearRegressionTrainConfig)config, terminationFlag, progressTracker, messageLogLevel);
            }
            case RandomForestRegression: {
                return new RandomForestRegressorTrainer(concurrency, (RandomForestRegressorTrainerConfig)config, randomSeed, terminationFlag, progressTracker, messageLogLevel);
            }
        }
        throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Method %s is not a regression method", (Object[])new Object[]{config.method()}));
    }
}

