/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.models;

import java.util.function.LongUnaryOperator;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.models.TrainerConfig;
import org.neo4j.gds.ml.models.logisticregression.LogisticRegressionClassifier;
import org.neo4j.gds.ml.models.logisticregression.LogisticRegressionData;
import org.neo4j.gds.ml.models.mlp.MLPClassifier;
import org.neo4j.gds.ml.models.mlp.MLPClassifierData;
import org.neo4j.gds.ml.models.randomforest.RandomForestClassifier;
import org.neo4j.gds.ml.models.randomforest.RandomForestClassifierData;
import org.neo4j.gds.ml.models.randomforest.RandomForestTrainerConfig;

public final class ClassifierFactory {
    private ClassifierFactory() {
    }

    public static Classifier create(Classifier.ClassifierData classifierData) {
        switch (classifierData.trainerMethod()) {
            case LogisticRegression: {
                return LogisticRegressionClassifier.from((LogisticRegressionData)classifierData);
            }
            case RandomForestClassification: {
                return new RandomForestClassifier((RandomForestClassifierData)classifierData);
            }
            case MLPClassification: {
                return new MLPClassifier((MLPClassifierData)classifierData);
            }
        }
        throw new IllegalStateException("No such classifier.");
    }

    public static MemoryRange runtimeOverheadMemoryEstimation(TrainingMethod method, int batchSize, int numberOfClasses, int featureDimension, boolean isReduced) {
        switch (method) {
            case LogisticRegression: {
                return LogisticRegressionClassifier.runtimeOverheadMemoryEstimation(batchSize, featureDimension, numberOfClasses, isReduced);
            }
            case RandomForestClassification: {
                return RandomForestClassifier.runtimeOverheadMemoryEstimation(numberOfClasses);
            }
            case MLPClassification: {
                return MemoryRange.empty();
            }
        }
        throw new IllegalStateException("No such classifier.");
    }

    public static MemoryEstimation dataMemoryEstimation(TrainerConfig trainerConfig, LongUnaryOperator numberOfTrainingSamples, int numberOfClasses, int featureDimension, boolean isReduced) {
        switch (trainerConfig.method()) {
            case LogisticRegression: {
                return LogisticRegressionData.memoryEstimation(isReduced, numberOfClasses, MemoryRange.of((long)featureDimension));
            }
            case RandomForestClassification: {
                return RandomForestClassifierData.memoryEstimation(numberOfTrainingSamples, (RandomForestTrainerConfig)((Object)trainerConfig));
            }
            case MLPClassification: {
                return MemoryEstimations.empty();
            }
        }
        throw new IllegalStateException("No such classifier.");
    }
}

