/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.metrics.regression;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.neo4j.gds.collections.ha.HugeDoubleArray;
import org.neo4j.gds.ml.metrics.Metric;
import org.neo4j.gds.utils.StringFormatting;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RegressionMetrics implements Metric
{
    MEAN_SQUARED_ERROR{

        @Override
        public Comparator<Double> comparator() {
            return Comparator.reverseOrder();
        }

        @Override
        public double compute(HugeDoubleArray targets, HugeDoubleArray predictions) {
            long numberOfExamples = targets.size();
            assert (numberOfExamples == predictions.size());
            double squaredError = 0.0;
            for (long i = 0L; i < numberOfExamples; ++i) {
                double error = predictions.get(i) - targets.get(i);
                squaredError += error * error;
            }
            return squaredError / (double)numberOfExamples;
        }
    }
    ,
    ROOT_MEAN_SQUARED_ERROR{

        @Override
        public Comparator<Double> comparator() {
            return Comparator.reverseOrder();
        }

        @Override
        public double compute(HugeDoubleArray targets, HugeDoubleArray predictions) {
            return Math.sqrt(MEAN_SQUARED_ERROR.compute(targets, predictions));
        }
    }
    ,
    MEAN_ABSOLUTE_ERROR{

        @Override
        public Comparator<Double> comparator() {
            return Comparator.reverseOrder();
        }

        @Override
        public double compute(HugeDoubleArray targets, HugeDoubleArray predictions) {
            long numberOfExamples = targets.size();
            assert (numberOfExamples == predictions.size());
            double totalError = 0.0;
            for (long i = 0L; i < numberOfExamples; ++i) {
                totalError += Math.abs(targets.get(i) - predictions.get(i));
            }
            return totalError / (double)numberOfExamples;
        }
    };

    private static final List<String> VALUES;

    public abstract double compute(HugeDoubleArray var1, HugeDoubleArray var2);

    public static List<RegressionMetrics> parseList(List<?> input) {
        return input.stream().map(RegressionMetrics::parse).collect(Collectors.toList());
    }

    public static RegressionMetrics parse(Object input) {
        if (input instanceof String) {
            String inputString = StringFormatting.toUpperCaseWithLocale((String)((String)input));
            if (VALUES.contains(inputString)) {
                return RegressionMetrics.valueOf(inputString.toUpperCase(Locale.ENGLISH));
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"RegressionMetric `%s` is not supported. Must be one of: %s.", (Object[])new Object[]{inputString, VALUES}));
        }
        if (input instanceof RegressionMetrics) {
            return (RegressionMetrics)input;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected RegressionMetric or String. Got %s.", (Object[])new Object[]{input.getClass().getSimpleName()}));
    }

    public static List<String> toString(List<RegressionMetrics> metrics) {
        return metrics.stream().map(Enum::name).collect(Collectors.toList());
    }

    static {
        VALUES = Arrays.stream(RegressionMetrics.values()).map(Enum::name).collect(Collectors.toList());
    }
}

