/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.metrics.classification;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.Objects;
import org.neo4j.gds.collections.ha.HugeIntArray;
import org.neo4j.gds.ml.metrics.classification.ClassificationMetric;
import org.neo4j.gds.utils.StringFormatting;

public class GlobalAccuracy
implements ClassificationMetric {
    public static final String NAME = "ACCURACY";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Comparator<Double> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public double compute(HugeIntArray targets, HugeIntArray predictions) {
        long accuratePredictions = 0L;
        assert (targets.size() == predictions.size()) : StringFormatting.formatWithLocale((String)"Metrics require equal length targets and predictions. Sizes are %d and %d respectively.", (Object[])new Object[]{targets.size(), predictions.size()});
        for (long row = 0L; row < targets.size(); ++row) {
            long targetClass = targets.get(row);
            long predictedClass = predictions.get(row);
            if (predictedClass != targetClass) continue;
            ++accuratePredictions;
        }
        if (targets.size() == 0L) {
            return 0.0;
        }
        return BigDecimal.valueOf(accuratePredictions).divide(BigDecimal.valueOf(targets.size()), 8, RoundingMode.UP).doubleValue();
    }

    public int hashCode() {
        return Objects.hash(NAME);
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public String toString() {
        return NAME;
    }
}

