/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.metrics.classification;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.gds.collections.ha.HugeIntArray;
import org.neo4j.gds.ml.core.subgraph.LocalIdMap;
import org.neo4j.gds.ml.metrics.classification.ClassificationMetric;
import org.neo4j.gds.ml.metrics.classification.F1Score;

public class F1Macro
implements ClassificationMetric {
    public static final String NAME = "F1_MACRO";
    private final LocalIdMap classIdMap;

    public F1Macro(LocalIdMap classIdMap) {
        this.classIdMap = classIdMap;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Comparator<Double> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public double compute(HugeIntArray targets, HugeIntArray predictions) {
        List metrics = this.classIdMap.getMappings().map(idMap -> new F1Score(idMap.key, idMap.value)).collect(Collectors.toList());
        return metrics.stream().mapToDouble(metric -> metric.compute(targets, predictions)).average().orElse(-1.0);
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass());
    }

    public int hashCode() {
        return Objects.hash(this.classIdMap);
    }

    public String toString() {
        return NAME;
    }
}

