/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.metrics.classification;

import java.util.Comparator;
import java.util.Objects;
import org.neo4j.gds.collections.ha.HugeIntArray;
import org.neo4j.gds.ml.metrics.classification.ClassificationMetric;
import org.neo4j.gds.utils.StringFormatting;

public class Accuracy
implements ClassificationMetric {
    public static final String NAME = "ACCURACY";
    private final long originalTarget;
    private final int internalTarget;

    public Accuracy(long originalTarget, int internalTarget) {
        this.originalTarget = originalTarget;
        this.internalTarget = internalTarget;
    }

    @Override
    public double compute(HugeIntArray targets, HugeIntArray predictions) {
        assert (targets.size() == predictions.size()) : StringFormatting.formatWithLocale((String)"Metrics require equal length targets and predictions. Sizes are %d and %d respectively.", (Object[])new Object[]{targets.size(), predictions.size()});
        if (targets.size() == 0L) {
            return 0.0;
        }
        long accurates = 0L;
        for (long row = 0L; row < targets.size(); ++row) {
            boolean targetIsPositive;
            long targetClass = targets.get(row);
            long predictedClass = predictions.get(row);
            boolean predictedIsPositive = predictedClass == (long)this.internalTarget;
            boolean bl = targetIsPositive = targetClass == (long)this.internalTarget;
            if (predictedIsPositive != targetIsPositive) continue;
            ++accurates;
        }
        return (double)accurates / (double)targets.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Accuracy accuracy = (Accuracy)o;
        return this.originalTarget == accuracy.originalTarget;
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public String toString() {
        return StringFormatting.formatWithLocale((String)"%s_class_%d", (Object[])new Object[]{NAME, this.originalTarget});
    }

    @Override
    public String name() {
        return StringFormatting.formatWithLocale((String)"%s(class=%d)", (Object[])new Object[]{NAME, this.originalTarget});
    }

    @Override
    public Comparator<Double> comparator() {
        return Comparator.naturalOrder();
    }
}

