/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.ml.metrics.EvaluationScores;
import org.neo4j.gds.ml.metrics.Metric;

public class ModelStatsBuilder {
    private final Map<Metric, Double> min;
    private final Map<Metric, Double> max;
    private final Map<Metric, Double> sum;
    private final int numberOfSplits;

    public ModelStatsBuilder(int numberOfSplits) {
        this.numberOfSplits = numberOfSplits;
        this.min = new HashMap<Metric, Double>();
        this.max = new HashMap<Metric, Double>();
        this.sum = new HashMap<Metric, Double>();
    }

    public void update(Metric metric, double value) {
        this.min.merge(metric, value, Math::min);
        this.max.merge(metric, value, Math::max);
        this.sum.merge(metric, value, Double::sum);
    }

    public EvaluationScores build(Metric metric) {
        return EvaluationScores.of(this.sum.get(metric) / (double)this.numberOfSplits, this.min.get(metric), this.max.get(metric));
    }

    public Map<Metric, EvaluationScores> build() {
        return this.sum.keySet().stream().collect(Collectors.toMap(Function.identity(), this::build));
    }

    public static long sizeInBytes(long numberOfMetrics) {
        int numberOfStats = 3;
        long statsMapEntries = (long)numberOfStats * (MemoryUsage.sizeOfInstance(HashMap.class) + numberOfMetrics * 8L);
        return MemoryUsage.sizeOfInstance(ModelStatsBuilder.class) + statsMapEntries;
    }
}

