/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.metrics;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.ml.metrics.Metric;
import org.neo4j.gds.ml.metrics.ModelStatsBuilder;

public final class ModelSpecificMetricsHandler {
    public static final ModelSpecificMetricsHandler NOOP = new ModelSpecificMetricsHandler(List.of(), (metric, score) -> {});
    private final List<? extends Metric> metrics;
    private final BiConsumer<Metric, Double> metricConsumer;

    private ModelSpecificMetricsHandler(List<? extends Metric> metrics, BiConsumer<Metric, Double> metricConsumer) {
        this.metrics = metrics;
        this.metricConsumer = metricConsumer;
    }

    public static ModelSpecificMetricsHandler of(List<? extends Metric> metrics, BiConsumer<Metric, Double> metricConsumer) {
        return new ModelSpecificMetricsHandler(metrics.stream().filter(Metric::isModelSpecific).collect(Collectors.toList()), metricConsumer);
    }

    public static ModelSpecificMetricsHandler of(List<? extends Metric> metrics, ModelStatsBuilder modelStatsBuilder) {
        return ModelSpecificMetricsHandler.of(metrics, modelStatsBuilder::update);
    }

    public boolean isRequested(Metric metric) {
        return this.metrics.contains(metric);
    }

    public void handle(Metric metric, double score) {
        if (!this.isRequested(metric)) {
            throw new IllegalStateException("Should not handle a metric which is not requested");
        }
        this.metricConsumer.accept(metric, score);
    }

    @TestOnly
    public static ModelSpecificMetricsHandler ignoringResult(List<Metric> metrics) {
        return new ModelSpecificMetricsHandler(metrics, (a, b) -> {});
    }
}

