/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.metrics.EvaluationScores;
import org.neo4j.gds.ml.metrics.Metric;
import org.neo4j.gds.ml.metrics.ModelCandidateStats;
import org.neo4j.gds.ml.models.TrainerConfig;

@Generated(from="ModelCandidateStats", generator="Immutables")
public final class ImmutableModelCandidateStats
implements ModelCandidateStats {
    private final TrainerConfig trainerConfig;
    private final Map<Metric, EvaluationScores> trainingStats;
    private final Map<Metric, EvaluationScores> validationStats;
    private final transient Map<String, Object> toMap;

    private ImmutableModelCandidateStats(TrainerConfig trainerConfig, Map<? extends Metric, ? extends EvaluationScores> trainingStats, Map<? extends Metric, ? extends EvaluationScores> validationStats) {
        this.trainerConfig = Objects.requireNonNull(trainerConfig, "trainerConfig");
        this.trainingStats = ImmutableModelCandidateStats.createUnmodifiableMap(true, false, trainingStats);
        this.validationStats = ImmutableModelCandidateStats.createUnmodifiableMap(true, false, validationStats);
        this.toMap = Objects.requireNonNull(ModelCandidateStats.super.toMap(), "toMap");
    }

    private ImmutableModelCandidateStats(ImmutableModelCandidateStats original, TrainerConfig trainerConfig, Map<Metric, EvaluationScores> trainingStats, Map<Metric, EvaluationScores> validationStats) {
        this.trainerConfig = trainerConfig;
        this.trainingStats = trainingStats;
        this.validationStats = validationStats;
        this.toMap = Objects.requireNonNull(ModelCandidateStats.super.toMap(), "toMap");
    }

    @Override
    public TrainerConfig trainerConfig() {
        return this.trainerConfig;
    }

    @Override
    public Map<Metric, EvaluationScores> trainingStats() {
        return this.trainingStats;
    }

    @Override
    public Map<Metric, EvaluationScores> validationStats() {
        return this.validationStats;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableModelCandidateStats withTrainerConfig(TrainerConfig value) {
        if (this.trainerConfig == value) {
            return this;
        }
        TrainerConfig newValue = Objects.requireNonNull(value, "trainerConfig");
        return new ImmutableModelCandidateStats(this, newValue, this.trainingStats, this.validationStats);
    }

    public final ImmutableModelCandidateStats withTrainingStats(Map<? extends Metric, ? extends EvaluationScores> entries) {
        if (this.trainingStats == entries) {
            return this;
        }
        Map<Metric, EvaluationScores> newValue = ImmutableModelCandidateStats.createUnmodifiableMap(true, false, entries);
        return new ImmutableModelCandidateStats(this, this.trainerConfig, newValue, this.validationStats);
    }

    public final ImmutableModelCandidateStats withValidationStats(Map<? extends Metric, ? extends EvaluationScores> entries) {
        if (this.validationStats == entries) {
            return this;
        }
        Map<Metric, EvaluationScores> newValue = ImmutableModelCandidateStats.createUnmodifiableMap(true, false, entries);
        return new ImmutableModelCandidateStats(this, this.trainerConfig, this.trainingStats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModelCandidateStats && this.equalTo(0, (ImmutableModelCandidateStats)another);
    }

    private boolean equalTo(int synthetic, ImmutableModelCandidateStats another) {
        return this.trainerConfig.equals(another.trainerConfig) && this.trainingStats.equals(another.trainingStats) && this.validationStats.equals(another.validationStats);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.trainerConfig.hashCode();
        h += (h << 5) + this.trainingStats.hashCode();
        h += (h << 5) + this.validationStats.hashCode();
        return h;
    }

    public String toString() {
        return "ModelCandidateStats{trainerConfig=" + this.trainerConfig + ", trainingStats=" + this.trainingStats + ", validationStats=" + this.validationStats + "}";
    }

    public static ModelCandidateStats of(TrainerConfig trainerConfig, Map<? extends Metric, ? extends EvaluationScores> trainingStats, Map<? extends Metric, ? extends EvaluationScores> validationStats) {
        return new ImmutableModelCandidateStats(trainerConfig, trainingStats, validationStats);
    }

    public static ModelCandidateStats copyOf(ModelCandidateStats instance) {
        if (instance instanceof ImmutableModelCandidateStats) {
            return (ImmutableModelCandidateStats)instance;
        }
        return ImmutableModelCandidateStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ModelCandidateStats", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TRAINER_CONFIG = 1L;
        private long initBits = 1L;
        private TrainerConfig trainerConfig;
        private Map<Metric, EvaluationScores> trainingStats = null;
        private Map<Metric, EvaluationScores> validationStats = null;

        private Builder() {
        }

        public final Builder from(ModelCandidateStats instance) {
            Objects.requireNonNull(instance, "instance");
            this.trainerConfig(instance.trainerConfig());
            this.putAllTrainingStats(instance.trainingStats());
            this.putAllValidationStats(instance.validationStats());
            return this;
        }

        public final Builder trainerConfig(TrainerConfig trainerConfig) {
            this.trainerConfig = Objects.requireNonNull(trainerConfig, "trainerConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putTrainingStat(Metric key, EvaluationScores value) {
            if (this.trainingStats == null) {
                this.trainingStats = new LinkedHashMap<Metric, EvaluationScores>();
            }
            this.trainingStats.put(Objects.requireNonNull(key, "trainingStats key"), Objects.requireNonNull(value, value == null ? "trainingStats value for key: " + key : null));
            return this;
        }

        public final Builder putTrainingStat(Map.Entry<? extends Metric, ? extends EvaluationScores> entry) {
            EvaluationScores v;
            if (this.trainingStats == null) {
                this.trainingStats = new LinkedHashMap<Metric, EvaluationScores>();
            }
            Metric k = entry.getKey();
            this.trainingStats.put(Objects.requireNonNull(k, "trainingStats key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "trainingStats value for key: " + k : null));
            return this;
        }

        public final Builder trainingStats(Map<? extends Metric, ? extends EvaluationScores> entries) {
            this.trainingStats = new LinkedHashMap<Metric, EvaluationScores>();
            return this.putAllTrainingStats(entries);
        }

        public final Builder putAllTrainingStats(Map<? extends Metric, ? extends EvaluationScores> entries) {
            if (this.trainingStats == null) {
                this.trainingStats = new LinkedHashMap<Metric, EvaluationScores>();
            }
            for (Map.Entry<? extends Metric, ? extends EvaluationScores> e : entries.entrySet()) {
                EvaluationScores v;
                Metric k = e.getKey();
                this.trainingStats.put(Objects.requireNonNull(k, "trainingStats key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "trainingStats value for key: " + k : null));
            }
            return this;
        }

        public final Builder putValidationStat(Metric key, EvaluationScores value) {
            if (this.validationStats == null) {
                this.validationStats = new LinkedHashMap<Metric, EvaluationScores>();
            }
            this.validationStats.put(Objects.requireNonNull(key, "validationStats key"), Objects.requireNonNull(value, value == null ? "validationStats value for key: " + key : null));
            return this;
        }

        public final Builder putValidationStat(Map.Entry<? extends Metric, ? extends EvaluationScores> entry) {
            EvaluationScores v;
            if (this.validationStats == null) {
                this.validationStats = new LinkedHashMap<Metric, EvaluationScores>();
            }
            Metric k = entry.getKey();
            this.validationStats.put(Objects.requireNonNull(k, "validationStats key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "validationStats value for key: " + k : null));
            return this;
        }

        public final Builder validationStats(Map<? extends Metric, ? extends EvaluationScores> entries) {
            this.validationStats = new LinkedHashMap<Metric, EvaluationScores>();
            return this.putAllValidationStats(entries);
        }

        public final Builder putAllValidationStats(Map<? extends Metric, ? extends EvaluationScores> entries) {
            if (this.validationStats == null) {
                this.validationStats = new LinkedHashMap<Metric, EvaluationScores>();
            }
            for (Map.Entry<? extends Metric, ? extends EvaluationScores> e : entries.entrySet()) {
                EvaluationScores v;
                Metric k = e.getKey();
                this.validationStats.put(Objects.requireNonNull(k, "validationStats key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "validationStats value for key: " + k : null));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.trainerConfig = null;
            if (this.trainingStats != null) {
                this.trainingStats.clear();
            }
            if (this.validationStats != null) {
                this.validationStats.clear();
            }
            return this;
        }

        public ModelCandidateStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModelCandidateStats(null, this.trainerConfig, this.trainingStats == null ? Collections.emptyMap() : ImmutableModelCandidateStats.createUnmodifiableMap(false, false, this.trainingStats), this.validationStats == null ? Collections.emptyMap() : ImmutableModelCandidateStats.createUnmodifiableMap(false, false, this.validationStats));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("trainerConfig");
            }
            return "Cannot build ModelCandidateStats, some of required attributes are not set " + attributes;
        }
    }
}

