/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.metrics;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.metrics.EvaluationScores;

@Generated(from="EvaluationScores", generator="Immutables")
public final class ImmutableEvaluationScores
implements EvaluationScores {
    private final double avg;
    private final double min;
    private final double max;
    private final transient Map<String, Object> toMap;

    private ImmutableEvaluationScores(double avg, double min, double max) {
        this.avg = avg;
        this.min = min;
        this.max = max;
        this.toMap = Objects.requireNonNull(EvaluationScores.super.toMap(), "toMap");
    }

    @Override
    public double avg() {
        return this.avg;
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableEvaluationScores withAvg(double value) {
        if (Double.doubleToLongBits(this.avg) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableEvaluationScores(value, this.min, this.max);
    }

    public final ImmutableEvaluationScores withMin(double value) {
        if (Double.doubleToLongBits(this.min) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableEvaluationScores(this.avg, value, this.max);
    }

    public final ImmutableEvaluationScores withMax(double value) {
        if (Double.doubleToLongBits(this.max) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableEvaluationScores(this.avg, this.min, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEvaluationScores && this.equalTo(0, (ImmutableEvaluationScores)another);
    }

    private boolean equalTo(int synthetic, ImmutableEvaluationScores another) {
        return Double.doubleToLongBits(this.avg) == Double.doubleToLongBits(another.avg) && Double.doubleToLongBits(this.min) == Double.doubleToLongBits(another.min) && Double.doubleToLongBits(this.max) == Double.doubleToLongBits(another.max) && this.toMap.equals(another.toMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Double.hashCode(this.avg);
        h += (h << 5) + Double.hashCode(this.min);
        h += (h << 5) + Double.hashCode(this.max);
        h += (h << 5) + this.toMap.hashCode();
        return h;
    }

    public String toString() {
        return "EvaluationScores{avg=" + this.avg + ", min=" + this.min + ", max=" + this.max + ", toMap=" + this.toMap + "}";
    }

    public static EvaluationScores of(double avg, double min, double max) {
        return new ImmutableEvaluationScores(avg, min, max);
    }

    public static EvaluationScores copyOf(EvaluationScores instance) {
        if (instance instanceof ImmutableEvaluationScores) {
            return (ImmutableEvaluationScores)instance;
        }
        return ImmutableEvaluationScores.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EvaluationScores", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_AVG = 1L;
        private static final long INIT_BIT_MIN = 2L;
        private static final long INIT_BIT_MAX = 4L;
        private long initBits = 7L;
        private double avg;
        private double min;
        private double max;

        private Builder() {
        }

        public final Builder from(EvaluationScores instance) {
            Objects.requireNonNull(instance, "instance");
            this.avg(instance.avg());
            this.min(instance.min());
            this.max(instance.max());
            return this;
        }

        public final Builder avg(double avg) {
            this.avg = avg;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder min(double min) {
            this.min = min;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder max(double max) {
            this.max = max;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.avg = 0.0;
            this.min = 0.0;
            this.max = 0.0;
            return this;
        }

        public EvaluationScores build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEvaluationScores(this.avg, this.min, this.max);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("avg");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("min");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("max");
            }
            return "Cannot build EvaluationScores, some of required attributes are not set " + attributes;
        }
    }
}

