/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.linkmodels.PredictedLink;

@Generated(from="PredictedLink", generator="Immutables")
public final class ImmutablePredictedLink
implements PredictedLink {
    private final long sourceId;
    private final long targetId;
    private final double probability;

    private ImmutablePredictedLink(long sourceId, long targetId, double probability) {
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.probability = probability;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    public long targetId() {
        return this.targetId;
    }

    @Override
    public double probability() {
        return this.probability;
    }

    public final ImmutablePredictedLink withSourceId(long value) {
        if (this.sourceId == value) {
            return this;
        }
        return new ImmutablePredictedLink(value, this.targetId, this.probability);
    }

    public final ImmutablePredictedLink withTargetId(long value) {
        if (this.targetId == value) {
            return this;
        }
        return new ImmutablePredictedLink(this.sourceId, value, this.probability);
    }

    public final ImmutablePredictedLink withProbability(double value) {
        if (Double.doubleToLongBits(this.probability) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePredictedLink(this.sourceId, this.targetId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePredictedLink && this.equalTo(0, (ImmutablePredictedLink)another);
    }

    private boolean equalTo(int synthetic, ImmutablePredictedLink another) {
        return this.sourceId == another.sourceId && this.targetId == another.targetId && Double.doubleToLongBits(this.probability) == Double.doubleToLongBits(another.probability);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.sourceId);
        h += (h << 5) + Long.hashCode(this.targetId);
        h += (h << 5) + Double.hashCode(this.probability);
        return h;
    }

    public String toString() {
        return "PredictedLink{sourceId=" + this.sourceId + ", targetId=" + this.targetId + ", probability=" + this.probability + "}";
    }

    public static PredictedLink of(long sourceId, long targetId, double probability) {
        return new ImmutablePredictedLink(sourceId, targetId, probability);
    }

    public static PredictedLink copyOf(PredictedLink instance) {
        if (instance instanceof ImmutablePredictedLink) {
            return (ImmutablePredictedLink)instance;
        }
        return ImmutablePredictedLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PredictedLink", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ID = 1L;
        private static final long INIT_BIT_TARGET_ID = 2L;
        private static final long INIT_BIT_PROBABILITY = 4L;
        private long initBits = 7L;
        private long sourceId;
        private long targetId;
        private double probability;

        private Builder() {
        }

        public final Builder from(PredictedLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceId(instance.sourceId());
            this.targetId(instance.targetId());
            this.probability(instance.probability());
            return this;
        }

        public final Builder sourceId(long sourceId) {
            this.sourceId = sourceId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder targetId(long targetId) {
            this.targetId = targetId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder probability(double probability) {
            this.probability = probability;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.sourceId = 0L;
            this.targetId = 0L;
            this.probability = 0.0;
            return this;
        }

        public PredictedLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePredictedLink(this.sourceId, this.targetId, this.probability);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("probability");
            }
            return "Cannot build PredictedLink, some of required attributes are not set " + attributes;
        }
    }
}

