/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.gds.core.utils.queue.BoundedLongLongPriorityQueue;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.PredictedLink;

public class ExhaustiveLinkPredictionResult
implements LinkPredictionResult {
    private final BoundedLongLongPriorityQueue predictionQueue;
    private final long linksConsidered;

    public ExhaustiveLinkPredictionResult(BoundedLongLongPriorityQueue bestPredictions, long linksConsidered) {
        this.predictionQueue = bestPredictions;
        this.linksConsidered = linksConsidered;
    }

    public int size() {
        return this.predictionQueue.size();
    }

    public void forEach(BoundedLongLongPriorityQueue.Consumer consumer) {
        this.predictionQueue.foreach(consumer);
    }

    @Override
    public Stream<PredictedLink> stream() {
        Iterable iterable = () -> new AbstractIterator<PredictedLink>(){
            final PrimitiveIterator.OfLong elements1Iter;
            final PrimitiveIterator.OfLong elements2Iter;
            final PrimitiveIterator.OfDouble prioritiesIter;
            {
                this.elements1Iter = ExhaustiveLinkPredictionResult.this.predictionQueue.elements1().iterator();
                this.elements2Iter = ExhaustiveLinkPredictionResult.this.predictionQueue.elements2().iterator();
                this.prioritiesIter = ExhaustiveLinkPredictionResult.this.predictionQueue.priorities().iterator();
            }

            protected PredictedLink fetch() {
                if (!this.elements1Iter.hasNext()) {
                    return (PredictedLink)this.done();
                }
                return PredictedLink.of(this.elements1Iter.nextLong(), this.elements2Iter.nextLong(), this.prioritiesIter.nextDouble());
            }
        };
        return StreamSupport.stream(iterable.spliterator(), true);
    }

    @Override
    public Map<String, Object> samplingStats() {
        return Map.of("strategy", "exhaustive", "linksConsidered", this.linksConsidered);
    }
}

