/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.gradientdescent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.gradientdescent.GradientDescentConfig;

public final class GradientDescentConfigImpl
implements GradientDescentConfig {
    private int batchSize;
    private int minEpochs;
    private int patience;
    private int maxEpochs;
    private double tolerance;
    private double learningRate;

    public GradientDescentConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.batchSize = config.getInt("batchSize", GradientDescentConfig.super.batchSize());
            CypherMapAccess.validateIntegerRange((String)"batchSize", (int)this.batchSize, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minEpochs = config.getInt("minEpochs", GradientDescentConfig.super.minEpochs());
            CypherMapAccess.validateIntegerRange((String)"minEpochs", (int)this.minEpochs, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.patience = config.getInt("patience", GradientDescentConfig.super.patience());
            CypherMapAccess.validateIntegerRange((String)"patience", (int)this.patience, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxEpochs = config.getInt("maxEpochs", GradientDescentConfig.super.maxEpochs());
            CypherMapAccess.validateIntegerRange((String)"maxEpochs", (int)this.maxEpochs, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.tolerance = config.getDouble("tolerance", GradientDescentConfig.super.tolerance());
            CypherMapAccess.validateDoubleRange((String)"tolerance", (double)this.tolerance, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.learningRate = config.getDouble("learningRate", GradientDescentConfig.super.learningRate());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public int minEpochs() {
        return this.minEpochs;
    }

    @Override
    public int patience() {
        return this.patience;
    }

    @Override
    public int maxEpochs() {
        return this.maxEpochs;
    }

    @Override
    public double tolerance() {
        return this.tolerance;
    }

    @Override
    public double learningRate() {
        return this.learningRate;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("batchSize", this.batchSize());
        map.put("minEpochs", this.minEpochs());
        map.put("patience", this.patience());
        map.put("maxEpochs", this.maxEpochs());
        map.put("tolerance", this.tolerance());
        map.put("learningRate", this.learningRate());
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(GradientDescentConfig baseConfig) {
            Builder builder = new Builder();
            builder.batchSize(baseConfig.batchSize());
            builder.minEpochs(baseConfig.minEpochs());
            builder.patience(baseConfig.patience());
            builder.maxEpochs(baseConfig.maxEpochs());
            builder.tolerance(baseConfig.tolerance());
            builder.learningRate(baseConfig.learningRate());
            return builder;
        }

        public Builder batchSize(int batchSize) {
            this.config.put("batchSize", batchSize);
            return this;
        }

        public Builder minEpochs(int minEpochs) {
            this.config.put("minEpochs", minEpochs);
            return this;
        }

        public Builder patience(int patience) {
            this.config.put("patience", patience);
            return this;
        }

        public Builder maxEpochs(int maxEpochs) {
            this.config.put("maxEpochs", maxEpochs);
            return this;
        }

        public Builder tolerance(double tolerance) {
            this.config.put("tolerance", tolerance);
            return this;
        }

        public Builder learningRate(double learningRate) {
            this.config.put("learningRate", learningRate);
            return this;
        }

        public GradientDescentConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GradientDescentConfigImpl((CypherMapAccess)config);
        }
    }
}

