/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.Objects;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.utils.StringFormatting;

public class TreeNode<PREDICTION extends Number> {
    private PREDICTION prediction;
    private int featureIndex = -1;
    private double thresholdValue;
    private TreeNode<PREDICTION> leftChild = null;
    private TreeNode<PREDICTION> rightChild = null;

    public TreeNode(int index, double value) {
        assert (index >= 0);
        this.featureIndex = index;
        this.thresholdValue = value;
    }

    public static long splitMemoryEstimation() {
        return MemoryUsage.sizeOfInstance(TreeNode.class);
    }

    public static <T extends Number> long leafMemoryEstimation(Class<T> leafType) {
        return MemoryUsage.sizeOfInstance(TreeNode.class) + MemoryUsage.sizeOfInstance(leafType);
    }

    public TreeNode(PREDICTION prediction) {
        this.prediction = prediction;
    }

    public void setPrediction(PREDICTION prediction) {
        this.prediction = prediction;
    }

    public PREDICTION prediction() {
        return this.prediction;
    }

    public int featureIndex() {
        return this.featureIndex;
    }

    public double thresholdValue() {
        return this.thresholdValue;
    }

    public TreeNode<PREDICTION> leftChild() {
        return this.leftChild;
    }

    public void setLeftChild(TreeNode leftChild) {
        this.leftChild = leftChild;
    }

    public boolean hasLeftChild() {
        return this.leftChild != null;
    }

    public TreeNode<PREDICTION> rightChild() {
        return this.rightChild;
    }

    public void setRightChild(TreeNode rightChild) {
        this.rightChild = rightChild;
    }

    public boolean hasRightChild() {
        return this.rightChild != null;
    }

    public String toString() {
        return StringFormatting.formatWithLocale((String)"Node: prediction %s, featureIndex %s, splitValue %f", (Object[])new Object[]{this.prediction, this.featureIndex, this.thresholdValue});
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        TreeNode.render(sb, this, 0);
        return sb.toString();
    }

    static void render(StringBuilder sb, TreeNode<?> node, int depth) {
        if (node == null) {
            return;
        }
        sb.append("\t".repeat(Math.max(0, depth - 1)));
        if (depth > 0) {
            sb.append("|-- ");
        }
        sb.append(node);
        sb.append(System.lineSeparator());
        TreeNode.render(sb, node.leftChild, depth + 1);
        TreeNode.render(sb, node.rightChild, depth + 1);
    }

    private static boolean equals(TreeNode o, TreeNode b) {
        if (o == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return o.featureIndex == b.featureIndex && Double.compare(o.thresholdValue, b.thresholdValue) == 0 && Objects.equals(o.prediction, b.prediction) && TreeNode.equals(o.leftChild, b.leftChild) && TreeNode.equals(o.rightChild, b.rightChild);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeNode treeNode = (TreeNode)o;
        return TreeNode.equals(this, treeNode);
    }

    public int hashCode() {
        return Objects.hash(this.prediction, this.featureIndex, this.thresholdValue, this.leftChild, this.rightChild);
    }
}

