/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.decisiontree.DecisionTreeTrainer;
import org.neo4j.gds.ml.decisiontree.TreeNode;

@Generated(from="DecisionTreeTrainer.StackRecord", generator="Immutables")
public final class ImmutableStackRecord<PREDICTION extends Number>
implements DecisionTreeTrainer.StackRecord<PREDICTION> {
    private final TreeNode<PREDICTION> node;
    private final DecisionTreeTrainer.Split split;
    private final int depth;

    private ImmutableStackRecord(TreeNode<PREDICTION> node, DecisionTreeTrainer.Split split, int depth) {
        this.node = Objects.requireNonNull(node, "node");
        this.split = Objects.requireNonNull(split, "split");
        this.depth = depth;
    }

    private ImmutableStackRecord(ImmutableStackRecord<PREDICTION> original, TreeNode<PREDICTION> node, DecisionTreeTrainer.Split split, int depth) {
        this.node = node;
        this.split = split;
        this.depth = depth;
    }

    @Override
    public TreeNode<PREDICTION> node() {
        return this.node;
    }

    @Override
    public DecisionTreeTrainer.Split split() {
        return this.split;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    public final ImmutableStackRecord<PREDICTION> withNode(TreeNode<PREDICTION> value) {
        if (this.node == value) {
            return this;
        }
        TreeNode<PREDICTION> newValue = Objects.requireNonNull(value, "node");
        return new ImmutableStackRecord<PREDICTION>(this, newValue, this.split, this.depth);
    }

    public final ImmutableStackRecord<PREDICTION> withSplit(DecisionTreeTrainer.Split value) {
        if (this.split == value) {
            return this;
        }
        DecisionTreeTrainer.Split newValue = Objects.requireNonNull(value, "split");
        return new ImmutableStackRecord<PREDICTION>(this, this.node, newValue, this.depth);
    }

    public final ImmutableStackRecord<PREDICTION> withDepth(int value) {
        if (this.depth == value) {
            return this;
        }
        return new ImmutableStackRecord<PREDICTION>(this, this.node, this.split, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStackRecord && this.equalTo(0, (ImmutableStackRecord)another);
    }

    private boolean equalTo(int synthetic, ImmutableStackRecord<?> another) {
        return this.node.equals(another.node) && this.split.equals(another.split) && this.depth == another.depth;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.split.hashCode();
        h += (h << 5) + this.depth;
        return h;
    }

    public String toString() {
        return "StackRecord{node=" + this.node + ", split=" + this.split + ", depth=" + this.depth + "}";
    }

    public static <PREDICTION extends Number> DecisionTreeTrainer.StackRecord<PREDICTION> of(TreeNode<PREDICTION> node, DecisionTreeTrainer.Split split, int depth) {
        return new ImmutableStackRecord<PREDICTION>(node, split, depth);
    }

    static <PREDICTION extends Number> DecisionTreeTrainer.StackRecord<PREDICTION> copyOf(DecisionTreeTrainer.StackRecord<PREDICTION> instance) {
        if (instance instanceof ImmutableStackRecord) {
            return (ImmutableStackRecord)instance;
        }
        return ImmutableStackRecord.builder().from(instance).build();
    }

    public static <PREDICTION extends Number> Builder<PREDICTION> builder() {
        return new Builder();
    }

    @Generated(from="DecisionTreeTrainer.StackRecord", generator="Immutables")
    static final class Builder<PREDICTION extends Number> {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_SPLIT = 2L;
        private static final long INIT_BIT_DEPTH = 4L;
        private long initBits = 7L;
        private TreeNode<PREDICTION> node;
        private DecisionTreeTrainer.Split split;
        private int depth;

        private Builder() {
        }

        public final Builder<PREDICTION> from(ImmutableStackRecord<PREDICTION> instance) {
            return this.from((DecisionTreeTrainer.StackRecord<PREDICTION>)instance);
        }

        final Builder<PREDICTION> from(DecisionTreeTrainer.StackRecord<PREDICTION> instance) {
            Objects.requireNonNull(instance, "instance");
            this.node(instance.node());
            this.split(instance.split());
            this.depth(instance.depth());
            return this;
        }

        public final Builder<PREDICTION> node(TreeNode<PREDICTION> node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<PREDICTION> split(DecisionTreeTrainer.Split split) {
            this.split = Objects.requireNonNull(split, "split");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<PREDICTION> depth(int depth) {
            this.depth = depth;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder<PREDICTION> clear() {
            this.initBits = 7L;
            this.node = null;
            this.split = null;
            this.depth = 0;
            return this;
        }

        public DecisionTreeTrainer.StackRecord<PREDICTION> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStackRecord<PREDICTION>(null, this.node, this.split, this.depth);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("split");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("depth");
            }
            return "Cannot build StackRecord, some of required attributes are not set " + attributes;
        }
    }
}

