/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.decisiontree.DecisionTreeTrainer;
import org.neo4j.gds.ml.decisiontree.Groups;

@Generated(from="DecisionTreeTrainer.Split", generator="Immutables")
public final class ImmutableSplit
implements DecisionTreeTrainer.Split {
    private final int index;
    private final double value;
    private final Groups groups;

    private ImmutableSplit(int index, double value, Groups groups) {
        this.index = index;
        this.value = value;
        this.groups = Objects.requireNonNull(groups, "groups");
    }

    private ImmutableSplit(ImmutableSplit original, int index, double value, Groups groups) {
        this.index = index;
        this.value = value;
        this.groups = groups;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public Groups groups() {
        return this.groups;
    }

    public final ImmutableSplit withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableSplit(this, value, this.value, this.groups);
    }

    public final ImmutableSplit withValue(double value) {
        if (Double.doubleToLongBits(this.value) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableSplit(this, this.index, value, this.groups);
    }

    public final ImmutableSplit withGroups(Groups value) {
        if (this.groups == value) {
            return this;
        }
        Groups newValue = Objects.requireNonNull(value, "groups");
        return new ImmutableSplit(this, this.index, this.value, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSplit && this.equalTo(0, (ImmutableSplit)another);
    }

    private boolean equalTo(int synthetic, ImmutableSplit another) {
        return this.index == another.index && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(another.value) && this.groups.equals(another.groups);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.index;
        h += (h << 5) + Double.hashCode(this.value);
        h += (h << 5) + this.groups.hashCode();
        return h;
    }

    public String toString() {
        return "Split{index=" + this.index + ", value=" + this.value + ", groups=" + this.groups + "}";
    }

    public static DecisionTreeTrainer.Split of(int index, double value, Groups groups) {
        return new ImmutableSplit(index, value, groups);
    }

    static DecisionTreeTrainer.Split copyOf(DecisionTreeTrainer.Split instance) {
        if (instance instanceof ImmutableSplit) {
            return (ImmutableSplit)instance;
        }
        return ImmutableSplit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DecisionTreeTrainer.Split", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_GROUPS = 4L;
        private long initBits = 7L;
        private int index;
        private double value;
        private Groups groups;

        private Builder() {
        }

        public final Builder from(ImmutableSplit instance) {
            return this.from((DecisionTreeTrainer.Split)instance);
        }

        final Builder from(DecisionTreeTrainer.Split instance) {
            Objects.requireNonNull(instance, "instance");
            this.index(instance.index());
            this.value(instance.value());
            this.groups(instance.groups());
            return this;
        }

        public final Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder value(double value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder groups(Groups groups) {
            this.groups = Objects.requireNonNull(groups, "groups");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.index = 0;
            this.value = 0.0;
            this.groups = null;
            return this;
        }

        public DecisionTreeTrainer.Split build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSplit(null, this.index, this.value, this.groups);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("groups");
            }
            return "Cannot build Split, some of required attributes are not set " + attributes;
        }
    }
}

