/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.decisiontree.Group;
import org.neo4j.gds.ml.decisiontree.Groups;

@Generated(from="Groups", generator="Immutables")
public final class ImmutableGroups
implements Groups {
    private final Group left;
    private final Group right;

    private ImmutableGroups(Group left, Group right) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    private ImmutableGroups(ImmutableGroups original, Group left, Group right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Group left() {
        return this.left;
    }

    @Override
    public Group right() {
        return this.right;
    }

    public final ImmutableGroups withLeft(Group value) {
        if (this.left == value) {
            return this;
        }
        Group newValue = Objects.requireNonNull(value, "left");
        return new ImmutableGroups(this, newValue, this.right);
    }

    public final ImmutableGroups withRight(Group value) {
        if (this.right == value) {
            return this;
        }
        Group newValue = Objects.requireNonNull(value, "right");
        return new ImmutableGroups(this, this.left, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroups && this.equalTo(0, (ImmutableGroups)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroups another) {
        return this.left.equals(another.left) && this.right.equals(another.right);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        return h;
    }

    public String toString() {
        return "Groups{left=" + this.left + ", right=" + this.right + "}";
    }

    public static Groups of(Group left, Group right) {
        return new ImmutableGroups(left, right);
    }

    static Groups copyOf(Groups instance) {
        if (instance instanceof ImmutableGroups) {
            return (ImmutableGroups)instance;
        }
        return ImmutableGroups.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Groups", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_LEFT = 1L;
        private static final long INIT_BIT_RIGHT = 2L;
        private long initBits = 3L;
        private Group left;
        private Group right;

        private Builder() {
        }

        public final Builder from(ImmutableGroups instance) {
            return this.from((Groups)instance);
        }

        final Builder from(Groups instance) {
            Objects.requireNonNull(instance, "instance");
            this.left(instance.left());
            this.right(instance.right());
            return this;
        }

        public final Builder left(Group left) {
            this.left = Objects.requireNonNull(left, "left");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder right(Group right) {
            this.right = Objects.requireNonNull(right, "right");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.left = null;
            this.right = null;
            return this;
        }

        public Groups build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroups(null, this.left, this.right);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("left");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("right");
            }
            return "Cannot build Groups, some of required attributes are not set " + attributes;
        }
    }
}

