/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.collections.ha.HugeLongArray;
import org.neo4j.gds.ml.decisiontree.Group;
import org.neo4j.gds.ml.decisiontree.ImpurityCriterion;

@Generated(from="Group", generator="Immutables")
public final class ImmutableGroup
implements Group {
    private final HugeLongArray array;
    private final long startIdx;
    private final long size;
    private final ImpurityCriterion.ImpurityData impurityData;

    private ImmutableGroup(HugeLongArray array, long startIdx, long size, ImpurityCriterion.ImpurityData impurityData) {
        this.array = Objects.requireNonNull(array, "array");
        this.startIdx = startIdx;
        this.size = size;
        this.impurityData = Objects.requireNonNull(impurityData, "impurityData");
    }

    private ImmutableGroup(ImmutableGroup original, HugeLongArray array, long startIdx, long size, ImpurityCriterion.ImpurityData impurityData) {
        this.array = array;
        this.startIdx = startIdx;
        this.size = size;
        this.impurityData = impurityData;
    }

    @Override
    public HugeLongArray array() {
        return this.array;
    }

    @Override
    public long startIdx() {
        return this.startIdx;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public ImpurityCriterion.ImpurityData impurityData() {
        return this.impurityData;
    }

    public final ImmutableGroup withArray(HugeLongArray value) {
        if (this.array == value) {
            return this;
        }
        HugeLongArray newValue = Objects.requireNonNull(value, "array");
        return new ImmutableGroup(this, newValue, this.startIdx, this.size, this.impurityData);
    }

    public final ImmutableGroup withStartIdx(long value) {
        if (this.startIdx == value) {
            return this;
        }
        return new ImmutableGroup(this, this.array, value, this.size, this.impurityData);
    }

    public final ImmutableGroup withSize(long value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableGroup(this, this.array, this.startIdx, value, this.impurityData);
    }

    public final ImmutableGroup withImpurityData(ImpurityCriterion.ImpurityData value) {
        if (this.impurityData == value) {
            return this;
        }
        ImpurityCriterion.ImpurityData newValue = Objects.requireNonNull(value, "impurityData");
        return new ImmutableGroup(this, this.array, this.startIdx, this.size, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroup && this.equalTo(0, (ImmutableGroup)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroup another) {
        return this.array.equals(another.array) && this.startIdx == another.startIdx && this.size == another.size && this.impurityData.equals(another.impurityData);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.array.hashCode();
        h += (h << 5) + Long.hashCode(this.startIdx);
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + this.impurityData.hashCode();
        return h;
    }

    public String toString() {
        return "Group{array=" + this.array + ", startIdx=" + this.startIdx + ", size=" + this.size + ", impurityData=" + this.impurityData + "}";
    }

    public static Group of(HugeLongArray array, long startIdx, long size, ImpurityCriterion.ImpurityData impurityData) {
        return new ImmutableGroup(array, startIdx, size, impurityData);
    }

    static Group copyOf(Group instance) {
        if (instance instanceof ImmutableGroup) {
            return (ImmutableGroup)instance;
        }
        return ImmutableGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Group", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_ARRAY = 1L;
        private static final long INIT_BIT_START_IDX = 2L;
        private static final long INIT_BIT_SIZE = 4L;
        private static final long INIT_BIT_IMPURITY_DATA = 8L;
        private long initBits = 15L;
        private HugeLongArray array;
        private long startIdx;
        private long size;
        private ImpurityCriterion.ImpurityData impurityData;

        private Builder() {
        }

        public final Builder from(ImmutableGroup instance) {
            return this.from((Group)instance);
        }

        final Builder from(Group instance) {
            Objects.requireNonNull(instance, "instance");
            this.array(instance.array());
            this.startIdx(instance.startIdx());
            this.size(instance.size());
            this.impurityData(instance.impurityData());
            return this;
        }

        public final Builder array(HugeLongArray array) {
            this.array = Objects.requireNonNull(array, "array");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder startIdx(long startIdx) {
            this.startIdx = startIdx;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder size(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder impurityData(ImpurityCriterion.ImpurityData impurityData) {
            this.impurityData = Objects.requireNonNull(impurityData, "impurityData");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.array = null;
            this.startIdx = 0L;
            this.size = 0L;
            this.impurityData = null;
            return this;
        }

        public Group build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroup(null, this.array, this.startIdx, this.size, this.impurityData);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("array");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("startIdx");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("impurityData");
            }
            return "Cannot build Group, some of required attributes are not set " + attributes;
        }
    }
}

