/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.SplittableRandom;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.ml.core.samplers.IntUniformSamplerFromRange;

public final class FeatureBagger {
    private final IntUniformSamplerFromRange sampler;
    private final int totalNumberOfFeatures;
    private final int numberOfSamples;

    public static MemoryRange memoryEstimation(int numberOfSamples) {
        return IntUniformSamplerFromRange.memoryEstimation((int)numberOfSamples).add(MemoryRange.of((long)MemoryUsage.sizeOfInstance(FeatureBagger.class)));
    }

    public FeatureBagger(SplittableRandom random, int totalNumberOfFeatures, double maxFeaturesRatio) {
        assert (Double.compare(maxFeaturesRatio, 0.0) != 0) : "Invalid maxFeaturesRatio";
        this.totalNumberOfFeatures = totalNumberOfFeatures;
        this.numberOfSamples = (int)Math.ceil(maxFeaturesRatio * (double)totalNumberOfFeatures);
        this.sampler = new IntUniformSamplerFromRange(random);
    }

    public int[] sample() {
        return this.sampler.sample(0, this.totalNumberOfFeatures, this.totalNumberOfFeatures, this.numberOfSamples, i -> false);
    }
}

