/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.decisiontree.DecisionTreeTrainerConfig;

public final class DecisionTreeTrainerConfigImpl
implements DecisionTreeTrainerConfig {
    private int maxDepth;
    private int minSplitSize;
    private int minLeafSize;

    public DecisionTreeTrainerConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.maxDepth = config.getInt("maxDepth", DecisionTreeTrainerConfig.super.maxDepth());
            CypherMapAccess.validateIntegerRange((String)"maxDepth", (int)this.maxDepth, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minSplitSize = config.getInt("minSplitSize", DecisionTreeTrainerConfig.super.minSplitSize());
            CypherMapAccess.validateIntegerRange((String)"minSplitSize", (int)this.minSplitSize, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.minLeafSize = config.getInt("minLeafSize", DecisionTreeTrainerConfig.super.minLeafSize());
            CypherMapAccess.validateIntegerRange((String)"minLeafSize", (int)this.minLeafSize, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateMinSizes();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int maxDepth() {
        return this.maxDepth;
    }

    @Override
    public int minSplitSize() {
        return this.minSplitSize;
    }

    @Override
    public int minLeafSize() {
        return this.minLeafSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(DecisionTreeTrainerConfig baseConfig) {
            Builder builder = new Builder();
            builder.maxDepth(baseConfig.maxDepth());
            builder.minSplitSize(baseConfig.minSplitSize());
            builder.minLeafSize(baseConfig.minLeafSize());
            return builder;
        }

        public Builder maxDepth(int maxDepth) {
            this.config.put("maxDepth", maxDepth);
            return this;
        }

        public Builder minSplitSize(int minSplitSize) {
            this.config.put("minSplitSize", minSplitSize);
            return this;
        }

        public Builder minLeafSize(int minLeafSize) {
            this.config.put("minLeafSize", minLeafSize);
            return this;
        }

        public DecisionTreeTrainerConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new DecisionTreeTrainerConfigImpl((CypherMapAccess)config);
        }
    }
}

