/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.utils.StringFormatting;

@Configuration
public interface DecisionTreeTrainerConfig {
    @Configuration.IntegerRange(min=1)
    default public int maxDepth() {
        return Integer.MAX_VALUE;
    }

    @Configuration.IntegerRange(min=2)
    default public int minSplitSize() {
        return 2;
    }

    @Configuration.IntegerRange(min=1)
    default public int minLeafSize() {
        return 1;
    }

    @Value.Check
    default public void validateMinSizes() {
        if (this.minLeafSize() >= this.minSplitSize()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameter 'minLeafSize' which was equal to %d, must be strictly smaller than configuration parameter 'minSplitSize' which was equal to %d", (Object[])new Object[]{this.minLeafSize(), this.minSplitSize()}));
        }
    }
}

