/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.Objects;
import org.neo4j.gds.ml.decisiontree.TreeNode;

public class DecisionTreePredictor<PREDICTION extends Number> {
    public final TreeNode<PREDICTION> root;

    public DecisionTreePredictor(TreeNode<PREDICTION> root) {
        this.root = root;
    }

    public PREDICTION predict(double[] features) {
        assert (features.length > 0);
        TreeNode<PREDICTION> node = this.root;
        while (node.leftChild() != null) {
            assert (features.length > node.featureIndex());
            assert (node.rightChild() != null);
            if (features[node.featureIndex()] < node.thresholdValue()) {
                node = node.leftChild();
                continue;
            }
            node = node.rightChild();
        }
        return node.prediction();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionTreePredictor that = (DecisionTreePredictor)o;
        return this.root.equals(that.root);
    }

    public int hashCode() {
        return Objects.hash(this.root);
    }
}

