/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.decisiontree;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public enum ClassifierImpurityCriterionType {
    GINI,
    ENTROPY;

    private static final List<String> VALUES;

    public static ClassifierImpurityCriterionType parse(Object input) {
        if (input instanceof String) {
            String inputString = ((String)input).toUpperCase(Locale.ENGLISH);
            if (VALUES.contains(inputString)) {
                return ClassifierImpurityCriterionType.valueOf(inputString);
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Impurity criterion `%s` is not supported. Must be one of: %s.", inputString, VALUES));
        }
        if (input instanceof ClassifierImpurityCriterionType) {
            return (ClassifierImpurityCriterionType)((Object)input);
        }
        throw new IllegalStateException(String.format(Locale.ENGLISH, "Expected impurity criterion or String. Got %s.", input.getClass().getSimpleName()));
    }

    public static String toString(ClassifierImpurityCriterionType criterionType) {
        return criterionType.toString();
    }

    static {
        VALUES = Arrays.stream(ClassifierImpurityCriterionType.values()).map(Enum::name).collect(Collectors.toList());
    }
}

