/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.legacycypherprojection.CypherQueryEstimator;

@Generated(from="CypherQueryEstimator.EstimationResult", generator="Immutables")
public final class ImmutableEstimationResult
implements CypherQueryEstimator.EstimationResult {
    private final long estimatedRows;
    private final long propertyCount;

    private ImmutableEstimationResult(long estimatedRows, long propertyCount) {
        this.estimatedRows = estimatedRows;
        this.propertyCount = propertyCount;
    }

    @Override
    public long estimatedRows() {
        return this.estimatedRows;
    }

    @Override
    public long propertyCount() {
        return this.propertyCount;
    }

    public final ImmutableEstimationResult withEstimatedRows(long value) {
        if (this.estimatedRows == value) {
            return this;
        }
        return new ImmutableEstimationResult(value, this.propertyCount);
    }

    public final ImmutableEstimationResult withPropertyCount(long value) {
        if (this.propertyCount == value) {
            return this;
        }
        return new ImmutableEstimationResult(this.estimatedRows, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEstimationResult && this.equalTo(0, (ImmutableEstimationResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableEstimationResult another) {
        return this.estimatedRows == another.estimatedRows && this.propertyCount == another.propertyCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.estimatedRows);
        h += (h << 5) + Long.hashCode(this.propertyCount);
        return h;
    }

    public String toString() {
        return "EstimationResult{estimatedRows=" + this.estimatedRows + ", propertyCount=" + this.propertyCount + "}";
    }

    public static CypherQueryEstimator.EstimationResult of(long estimatedRows, long propertyCount) {
        return new ImmutableEstimationResult(estimatedRows, propertyCount);
    }

    public static CypherQueryEstimator.EstimationResult copyOf(CypherQueryEstimator.EstimationResult instance) {
        if (instance instanceof ImmutableEstimationResult) {
            return (ImmutableEstimationResult)instance;
        }
        return ImmutableEstimationResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CypherQueryEstimator.EstimationResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ESTIMATED_ROWS = 1L;
        private static final long INIT_BIT_PROPERTY_COUNT = 2L;
        private long initBits = 3L;
        private long estimatedRows;
        private long propertyCount;

        private Builder() {
        }

        public final Builder from(CypherQueryEstimator.EstimationResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.estimatedRows(instance.estimatedRows());
            this.propertyCount(instance.propertyCount());
            return this;
        }

        public final Builder estimatedRows(long estimatedRows) {
            this.estimatedRows = estimatedRows;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder propertyCount(long propertyCount) {
            this.propertyCount = propertyCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.estimatedRows = 0L;
            this.propertyCount = 0L;
            return this;
        }

        public CypherQueryEstimator.EstimationResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEstimationResult(this.estimatedRows, this.propertyCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("estimatedRows");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("propertyCount");
            }
            return "Cannot build EstimationResult, some of required attributes are not set " + attributes;
        }
    }
}

