/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.legacycypherprojection.GraphProjectFromCypherConfig;

public final class GraphProjectFromCypherConfigImpl
implements GraphProjectFromCypherConfig {
    private String nodeQuery;
    private String relationshipQuery;
    private Map<String, Object> parameters;
    private boolean validateRelationships;
    private boolean sudo;
    private String username;
    private String graphName;
    private int readConcurrency;
    private long nodeCount;
    private long relationshipCount;
    private ZonedDateTime creationTime;
    private Optional<String> usernameOverride;
    private boolean logProgress;
    private JobId jobId;

    public GraphProjectFromCypherConfigImpl(@NotNull String username, @NotNull String graphName, @NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.nodeQuery = (String)CypherMapAccess.failOnNull((String)"nodeQuery", (Object)StringUtils.trimToNull((String)config.requireString("nodeQuery")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipQuery = (String)CypherMapAccess.failOnNull((String)"relationshipQuery", (Object)StringUtils.trimToNull((String)config.requireString("relationshipQuery")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.parameters = (Map)CypherMapAccess.failOnNull((String)"parameters", (Object)((Map)config.getChecked("parameters", GraphProjectFromCypherConfig.super.parameters(), Map.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateRelationships = config.getBool("validateRelationships", GraphProjectFromCypherConfig.super.validateRelationships());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphProjectFromCypherConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapAccess.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = GraphProjectConfig.validateName((String)((String)CypherMapAccess.failOnNull((String)"graphName", (Object)graphName)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.readConcurrency = config.getInt("readConcurrency", GraphProjectFromCypherConfig.super.readConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeCount = config.getLong("nodeCount", GraphProjectFromCypherConfig.super.nodeCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipCount = config.getLong("relationshipCount", GraphProjectFromCypherConfig.super.relationshipCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.creationTime = (ZonedDateTime)CypherMapAccess.failOnNull((String)"creationTime", (Object)((ZonedDateTime)config.getChecked("creationTime", (Object)GraphProjectFromCypherConfig.super.creationTime(), ZonedDateTime.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", GraphProjectFromCypherConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)GraphProjectFromCypherConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateReadConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String nodeQuery() {
        return this.nodeQuery;
    }

    @Override
    public String relationshipQuery() {
        return this.relationshipQuery;
    }

    @Override
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    @Override
    public boolean validateRelationships() {
        return this.validateRelationships;
    }

    @Override
    public boolean sudo() {
        return this.sudo;
    }

    public String username() {
        return this.username;
    }

    public String graphName() {
        return this.graphName;
    }

    public int readConcurrency() {
        return this.readConcurrency;
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public long relationshipCount() {
        return this.relationshipCount;
    }

    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("nodeQuery", "relationshipQuery", "parameters", "validateRelationships", "sudo", "readConcurrency", "nodeCount", "relationshipCount", "creationTime", "username", "logProgress", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("nodeQuery", this.nodeQuery());
        map.put("relationshipQuery", this.relationshipQuery());
        map.put("parameters", GraphProjectFromCypherConfig.listParameterKeys(this.parameters()));
        map.put("validateRelationships", this.validateRelationships());
        map.put("sudo", this.sudo());
        map.put("readConcurrency", this.readConcurrency());
        map.put("nodeCount", this.nodeCount());
        map.put("relationshipCount", this.relationshipCount());
        map.put("creationTime", this.creationTime());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("logProgress", this.logProgress());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        return map;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String username;
        @NotNull
        private String graphName;

        public static Builder from(GraphProjectFromCypherConfig baseConfig) {
            Builder builder = new Builder();
            builder.nodeQuery(baseConfig.nodeQuery());
            builder.relationshipQuery(baseConfig.relationshipQuery());
            builder.parameters(baseConfig.parameters());
            builder.validateRelationships(baseConfig.validateRelationships());
            builder.sudo(baseConfig.sudo());
            builder.username(baseConfig.username());
            builder.graphName(baseConfig.graphName());
            builder.readConcurrency(baseConfig.readConcurrency());
            builder.nodeCount(baseConfig.nodeCount());
            builder.relationshipCount(baseConfig.relationshipCount());
            builder.creationTime(baseConfig.creationTime());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.logProgress(baseConfig.logProgress());
            builder.jobId(baseConfig.jobId());
            return builder;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder nodeQuery(String nodeQuery) {
            this.config.put("nodeQuery", nodeQuery);
            return this;
        }

        public Builder relationshipQuery(String relationshipQuery) {
            this.config.put("relationshipQuery", relationshipQuery);
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.config.put("parameters", parameters);
            return this;
        }

        public Builder validateRelationships(boolean validateRelationships) {
            this.config.put("validateRelationships", validateRelationships);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder readConcurrency(int readConcurrency) {
            this.config.put("readConcurrency", readConcurrency);
            return this;
        }

        public Builder nodeCount(long nodeCount) {
            this.config.put("nodeCount", nodeCount);
            return this;
        }

        public Builder relationshipCount(long relationshipCount) {
            this.config.put("relationshipCount", relationshipCount);
            return this;
        }

        public Builder creationTime(ZonedDateTime creationTime) {
            this.config.put("creationTime", creationTime);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public GraphProjectFromCypherConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphProjectFromCypherConfigImpl(this.username, this.graphName, (CypherMapAccess)config);
        }
    }
}

