/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.legacycypherprojection.CypherFactory;
import org.neo4j.gds.legacycypherprojection.GraphProjectFromCypherConfigImpl;
import org.neo4j.gds.utils.StringFormatting;

@Configuration
public interface GraphProjectFromCypherConfig
extends GraphProjectConfig {
    public static final List<String> FORBIDDEN_KEYS = Arrays.asList("nodeProjection", "relationshipProjection", "nodeProperties", "relationshipProperties");
    public static final String NODE_QUERY_KEY = "nodeQuery";
    public static final String RELATIONSHIP_QUERY_KEY = "relationshipQuery";
    public static final String ALL_NODES_QUERY = "MATCH (n) RETURN id(n) AS id";
    public static final String ALL_RELATIONSHIPS_QUERY = "MATCH (a)-->(b) RETURN id(a) AS source, id(b) AS target";

    @Configuration.Ignore
    default public Map<String, Object> asProcedureResultConfigurationField() {
        return this.cleansed(this.toMap(), this.outputFieldDenylist());
    }

    @Configuration.ConvertWith(method="org.apache.commons.lang3.StringUtils#trimToNull")
    public String nodeQuery();

    @Configuration.ConvertWith(method="org.apache.commons.lang3.StringUtils#trimToNull")
    public String relationshipQuery();

    @Configuration.ToMapValue(value="org.neo4j.gds.legacycypherprojection.GraphProjectFromCypherConfig#listParameterKeys")
    default public Map<String, Object> parameters() {
        return Collections.emptyMap();
    }

    default public boolean validateRelationships() {
        return true;
    }

    @Configuration.Ignore
    default public GraphStoreFactory.Supplier graphStoreFactory() {
        return new GraphStoreFactory.Supplier(){

            public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> get(GraphLoaderContext loaderContext) {
                return CypherFactory.createWithDerivedDimensions(GraphProjectFromCypherConfig.this, loaderContext);
            }

            public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> getWithDimension(GraphLoaderContext loaderContext, GraphDimensions graphDimensions) {
                return CypherFactory.createWithBaseDimensions(GraphProjectFromCypherConfig.this, loaderContext, graphDimensions);
            }
        };
    }

    default public boolean sudo() {
        return true;
    }

    @Configuration.Ignore
    default public Set<String> outputFieldDenylist() {
        return Set.of("nodeCount", "relationshipCount");
    }

    public static GraphProjectFromCypherConfig of(String userName, String graphName, String nodeQuery, String relationshipQuery, CypherMapWrapper config) {
        GraphProjectFromCypherConfig.assertNoProjectionsOrExplicitProperties(config);
        if (nodeQuery != null) {
            config = config.withString(NODE_QUERY_KEY, nodeQuery);
        }
        if (relationshipQuery != null) {
            config = config.withString(RELATIONSHIP_QUERY_KEY, relationshipQuery);
        }
        return new GraphProjectFromCypherConfigImpl(userName, graphName, (CypherMapAccess)config);
    }

    public static GraphProjectFromCypherConfig fromProcedureConfig(String username, CypherMapWrapper config) {
        GraphProjectFromCypherConfig.assertNoProjectionsOrExplicitProperties(config);
        return new GraphProjectFromCypherConfigImpl(username, "", (CypherMapAccess)config);
    }

    public static void assertNoProjectionsOrExplicitProperties(CypherMapWrapper config) {
        for (String forbiddenKey : FORBIDDEN_KEYS) {
            if (!config.containsKey(forbiddenKey)) continue;
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid key: %s", (Object[])new Object[]{forbiddenKey}));
        }
    }

    public static Collection<String> listParameterKeys(Map<String, Object> parameters) {
        return parameters.keySet();
    }
}

