/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import org.immutables.value.Value;
import org.neo4j.gds.ImmutablePropertyMappings;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.RelationshipImportResult;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.legacycypherprojection.BatchLoadResult;
import org.neo4j.gds.legacycypherprojection.CypherLoadingUtils;
import org.neo4j.gds.legacycypherprojection.CypherRecordLoader;
import org.neo4j.gds.legacycypherprojection.GraphProjectFromCypherConfig;
import org.neo4j.gds.legacycypherprojection.RelationshipSubscriber;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.QuerySubscription;

@Value.Enclosing
class CypherRelationshipLoader
extends CypherRecordLoader<RelationshipImportResult> {
    private final IdMap idMap;
    private final Context loaderContext;
    private final ProgressTracker progressTracker;
    private ObjectDoubleHashMap<String> propertyDefaultValueByName;
    private boolean initializedFromResult;
    private List<GraphFactory.PropertyConfig> propertyConfigs;

    CypherRelationshipLoader(String relationshipQuery, IdMap idMap, GraphProjectFromCypherConfig config, GraphLoaderContext loadingContext, ProgressTracker progressTracker) {
        super(relationshipQuery, idMap.nodeCount(), config, loadingContext);
        this.idMap = idMap;
        this.progressTracker = progressTracker;
        this.loaderContext = new Context();
    }

    private void initFromPropertyMappings(PropertyMappings propertyMappings) {
        this.propertyDefaultValueByName = new ObjectDoubleHashMap(propertyMappings.numberOfMappings());
        propertyMappings.stream().forEach(mapping -> this.propertyDefaultValueByName.put((Object)mapping.neoPropertyKey(), mapping.defaultValue().doubleValue()));
        this.propertyConfigs = propertyMappings.stream().map(mapping -> GraphFactory.PropertyConfig.of((String)mapping.propertyKey(), (Aggregation)mapping.aggregation(), (DefaultValue)mapping.defaultValue())).collect(Collectors.toList());
    }

    @Override
    BatchLoadResult loadSingleBatch(InternalTransaction tx, int bufferSize) {
        this.progressTracker.beginSubTask("Relationships");
        RelationshipSubscriber subscriber = new RelationshipSubscriber(this.idMap, this.loaderContext, this.cypherConfig.validateRelationships(), this.progressTracker);
        QueryExecution subscription = this.runLoadingQuery(tx, (QuerySubscriber)subscriber);
        if (!this.initializedFromResult) {
            List propertyMappings = this.getPropertyColumns(subscription).stream().map(propertyColumn -> PropertyMapping.of((String)propertyColumn, (String)propertyColumn, (DefaultValue)DefaultValue.forDouble(), (Aggregation)Aggregation.NONE)).collect(Collectors.toList());
            this.initFromPropertyMappings(ImmutablePropertyMappings.of(propertyMappings));
            this.initializedFromResult = true;
        }
        subscriber.initialize(subscription.fieldNames(), (ObjectDoubleMap<String>)this.propertyDefaultValueByName);
        CypherLoadingUtils.consume((QuerySubscription)subscription);
        subscriber.error().ifPresent(e -> {
            throw e;
        });
        this.progressTracker.endSubTask("Relationships");
        return new BatchLoadResult(subscriber.rows(), -1L);
    }

    @Override
    void updateCounts(BatchLoadResult result) {
    }

    @Override
    RelationshipImportResult result() {
        Map<RelationshipType, SingleTypeRelationships> relationshipsByType = this.loaderContext.relationshipBuildersByType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((RelationshipsBuilder)entry.getValue()).build()));
        return RelationshipImportResult.of(relationshipsByType);
    }

    @Override
    Set<String> getMandatoryColumns() {
        return RelationshipSubscriber.REQUIRED_COLUMNS;
    }

    @Override
    Set<String> getReservedColumns() {
        return RelationshipSubscriber.RESERVED_COLUMNS;
    }

    @Override
    CypherRecordLoader.QueryType queryType() {
        return CypherRecordLoader.QueryType.RELATIONSHIP;
    }

    class Context {
        private final Map<RelationshipType, RelationshipsBuilder> relationshipBuildersByType = new HashMap<RelationshipType, RelationshipsBuilder>();

        Context() {
        }

        RelationshipsBuilder getOrCreateRelationshipsBuilder(RelationshipType relationshipType) {
            return this.relationshipBuildersByType.computeIfAbsent(relationshipType, this::createRelationshipsBuilder);
        }

        private RelationshipsBuilder createRelationshipsBuilder(RelationshipType relationshipType) {
            return GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)CypherRelationshipLoader.this.idMap).relationshipType(relationshipType).concurrency(CypherRelationshipLoader.this.cypherConfig.readConcurrency()).propertyConfigs(CypherRelationshipLoader.this.propertyConfigs).orientation(Orientation.NATURAL).skipDanglingRelationships(!CypherRelationshipLoader.this.cypherConfig.validateRelationships()).build();
        }
    }
}

