/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.common.DependencyResolver;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.legacycypherprojection.BatchLoadResult;
import org.neo4j.gds.legacycypherprojection.GraphProjectFromCypherConfig;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.virtual.MapValue;

abstract class CypherRecordLoader<R> {
    static final long NO_COUNT = -1L;
    final GraphProjectFromCypherConfig cypherConfig;
    private final long recordCount;
    protected final String loadQuery;
    private final QueryExecutionEngine executionEngine;
    private final TransactionalContextFactory contextFactory;

    CypherRecordLoader(String loadQuery, long recordCount, GraphProjectFromCypherConfig cypherConfig, GraphLoaderContext loadingContext) {
        this.loadQuery = loadQuery;
        this.recordCount = recordCount;
        this.cypherConfig = cypherConfig;
        DependencyResolver dependencyResolver = loadingContext.dependencyResolver();
        this.executionEngine = (QueryExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class);
        this.contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)((GraphDatabaseQueryService)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class)));
    }

    final R load(InternalTransaction transaction) {
        try {
            int bufferSize = (int)Math.min(this.recordCount, 100000L);
            BatchLoadResult result = this.loadSingleBatch(transaction, bufferSize);
            this.updateCounts(result);
            return this.result();
        }
        catch (AuthorizationViolationException ex) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Query must be read only. Query: [%s]", (Object[])new Object[]{this.loadQuery}));
        }
    }

    abstract QueryType queryType();

    abstract BatchLoadResult loadSingleBatch(InternalTransaction var1, int var2);

    abstract void updateCounts(BatchLoadResult var1);

    abstract R result();

    abstract Set<String> getMandatoryColumns();

    abstract Set<String> getReservedColumns();

    Collection<String> getPropertyColumns(QueryExecution queryResult) {
        Predicate<String> contains = this.getReservedColumns()::contains;
        return Arrays.stream(queryResult.fieldNames()).filter(contains.negate()).collect(Collectors.toList());
    }

    boolean columnsContains(QueryExecution queryResult, String name) {
        for (String fieldName : queryResult.fieldNames()) {
            if (!fieldName.equals(name)) continue;
            return true;
        }
        return false;
    }

    QueryExecution runLoadingQuery(InternalTransaction tx, QuerySubscriber subscriber) {
        QueryExecution result = CypherRecordLoader.runQueryWithoutClosingTheResult(tx, this.loadQuery, this.cypherConfig.parameters(), this.contextFactory, this.executionEngine, subscriber);
        this.validateMandatoryColumns(Arrays.asList(result.fieldNames()));
        return result;
    }

    private void validateMandatoryColumns(Collection<String> allColumns) {
        HashSet<String> missingColumns = new HashSet<String>(this.getMandatoryColumns());
        missingColumns.removeAll(allColumns);
        if (!missingColumns.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid %s query, required column(s) not found: '%s' - did you specify %s?", (Object[])new Object[]{this.queryType().toLowerCase(), StringJoining.join(missingColumns, (CharSequence)"', '"), StringJoining.joinVerbose((Collection)missingColumns.stream().map(column -> "'AS " + column + "'").collect(Collectors.toList()))}));
        }
    }

    private static QueryExecution runQueryWithoutClosingTheResult(InternalTransaction tx, String query, Map<String, Object> params, TransactionalContextFactory contextFactory, QueryExecutionEngine executionEngine, QuerySubscriber subscriber) {
        MapValue convertedParams = ValueUtils.asMapValue(params);
        TransactionalContext context = Neo4jProxy.newQueryContext((TransactionalContextFactory)contextFactory, (InternalTransaction)tx, (String)query, (MapValue)convertedParams);
        try {
            return executionEngine.executeQuery(query, convertedParams, context, false, subscriber);
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    static enum QueryType {
        NODE,
        RELATIONSHIP;


        String toLowerCase() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

