/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.legacycypherprojection.ImmutableEstimationResult;
import org.neo4j.gds.legacycypherprojection.NodeSubscriber;
import org.neo4j.gds.legacycypherprojection.RelationshipSubscriber;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.kernel.api.security.AccessMode;

public class CypherQueryEstimator {
    private final TransactionContext context;

    public CypherQueryEstimator(TransactionContext context) {
        this.context = context;
    }

    public EstimationResult getNodeEstimation(String nodeQuery) {
        return this.runEstimationQuery(nodeQuery, NodeSubscriber.RESERVED_COLUMNS);
    }

    public EstimationResult getRelationshipEstimation(String relationshipQuery) {
        return this.runEstimationQuery(relationshipQuery, RelationshipSubscriber.RESERVED_COLUMNS);
    }

    private EstimationResult runEstimationQuery(String query, Collection<String> reservedColumns) {
        return (EstimationResult)this.context.withRestrictedAccess(AccessMode.Static.READ).apply((tx, ktx) -> {
            String explainQuery = StringFormatting.formatWithLocale((String)"EXPLAIN %s", (Object[])new Object[]{query});
            try (Result result = tx.execute(explainQuery);){
                Number estimatedRows = (Number)result.getExecutionPlanDescription().getArguments().get("EstimatedRows");
                ArrayList<String> propertyColumns = new ArrayList<String>(result.columns());
                propertyColumns.removeAll(reservedColumns);
                propertyColumns.forEach(PropertyMapping::validatePropertyKey);
                EstimationResult estimationResult = ImmutableEstimationResult.of(estimatedRows.longValue(), propertyColumns.size());
                return estimationResult;
            }
        });
    }

    @ValueClass
    public static interface EstimationResult {
        public long estimatedRows();

        public long propertyCount();
    }
}

