/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.util.Collection;
import java.util.Set;
import org.immutables.value.Value;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.core.loading.Nodes;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.legacycypherprojection.BatchLoadResult;
import org.neo4j.gds.legacycypherprojection.CypherLoadingUtils;
import org.neo4j.gds.legacycypherprojection.CypherRecordLoader;
import org.neo4j.gds.legacycypherprojection.GraphProjectFromCypherConfig;
import org.neo4j.gds.legacycypherprojection.NodeSubscriber;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.QuerySubscription;

@Value.Enclosing
class CypherNodeLoader
extends CypherRecordLoader<Nodes> {
    private final long nodeCount;
    private final ProgressTracker progressTracker;
    private long highestNodeId;
    private NodesBuilder nodesBuilder;

    CypherNodeLoader(String nodeQuery, long nodeCount, GraphProjectFromCypherConfig config, GraphLoaderContext loadingContext, ProgressTracker progressTracker) {
        super(nodeQuery, nodeCount, config, loadingContext);
        this.nodeCount = nodeCount;
        this.progressTracker = progressTracker;
        this.highestNodeId = 0L;
    }

    @Override
    BatchLoadResult loadSingleBatch(InternalTransaction tx, int bufferSize) {
        this.progressTracker.beginSubTask("Nodes");
        this.progressTracker.setVolume(this.nodeCount);
        NodeSubscriber nodeSubscriber = new NodeSubscriber(this.progressTracker);
        QueryExecution subscription = this.runLoadingQuery(tx, (QuerySubscriber)nodeSubscriber);
        Collection<String> propertyColumns = this.getPropertyColumns(subscription);
        boolean hasLabelInformation = this.columnsContains(subscription, "labels");
        this.nodesBuilder = GraphFactory.initNodesBuilder().nodeCount(this.nodeCount).maxOriginalId(-1L).hasLabelInformation(hasLabelInformation).hasProperties(!propertyColumns.isEmpty()).propertyState(PropertyState.TRANSIENT).build();
        nodeSubscriber.initialize(subscription.fieldNames(), this.nodesBuilder);
        try {
            CypherLoadingUtils.consume((QuerySubscription)subscription);
        }
        catch (RuntimeException e) {
            this.nodesBuilder.close(e);
        }
        nodeSubscriber.error().ifPresent(error -> this.nodesBuilder.close(error));
        long rows = nodeSubscriber.rows();
        if (rows == 0L) {
            this.nodesBuilder.close((RuntimeException)new IllegalArgumentException("Node-Query returned no nodes"));
        }
        this.progressTracker.endSubTask("Nodes");
        return new BatchLoadResult(rows, nodeSubscriber.maxId());
    }

    @Override
    void updateCounts(BatchLoadResult result) {
        if (result.maxId() > this.highestNodeId) {
            this.highestNodeId = result.maxId();
        }
    }

    @Override
    Nodes result() {
        return this.nodesBuilder.build(this.highestNodeId);
    }

    @Override
    Set<String> getMandatoryColumns() {
        return NodeSubscriber.REQUIRED_COLUMNS;
    }

    @Override
    Set<String> getReservedColumns() {
        return NodeSubscriber.RESERVED_COLUMNS;
    }

    @Override
    CypherRecordLoader.QueryType queryType() {
        return CypherRecordLoader.QueryType.NODE;
    }
}

