/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.CSRGraphStoreFactory;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.ImmutableGraphDimensions;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.loading.ImmutableStaticCapabilities;
import org.neo4j.gds.core.loading.Nodes;
import org.neo4j.gds.core.loading.RelationshipImportResult;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskTreeProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.legacycypherprojection.BatchLoadResult;
import org.neo4j.gds.legacycypherprojection.CountingCypherRecordLoader;
import org.neo4j.gds.legacycypherprojection.CypherNodeLoader;
import org.neo4j.gds.legacycypherprojection.CypherQueryEstimator;
import org.neo4j.gds.legacycypherprojection.CypherRecordLoader;
import org.neo4j.gds.legacycypherprojection.CypherRelationshipLoader;
import org.neo4j.gds.legacycypherprojection.GraphProjectFromCypherConfig;
import org.neo4j.gds.legacycypherprojection.ImmutableEstimationResult;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.internal.kernel.api.security.AccessMode;

public final class CypherFactory
extends CSRGraphStoreFactory<GraphProjectFromCypherConfig> {
    private final GraphProjectFromCypherConfig cypherConfig;
    private final long numberOfNodeProperties;
    private final long numberOfRelationshipProperties;
    private final ProgressTracker progressTracker;

    public static CypherFactory createWithBaseDimensions(GraphProjectFromCypherConfig graphProjectConfig, GraphLoaderContext loadingContext, GraphDimensions graphDimensions) {
        return CypherFactory.create(graphProjectConfig, loadingContext, Optional.of(graphDimensions));
    }

    public static CypherFactory createWithDerivedDimensions(GraphProjectFromCypherConfig graphProjectConfig, GraphLoaderContext loadingContext) {
        return CypherFactory.create(graphProjectConfig, loadingContext, Optional.empty());
    }

    private static CypherFactory create(GraphProjectFromCypherConfig graphProjectConfig, GraphLoaderContext loadingContext, Optional<GraphDimensions> baseDimensions) {
        CypherQueryEstimator.EstimationResult relationEstimation;
        CypherQueryEstimator.EstimationResult nodeEstimation;
        if (graphProjectConfig.isFictitiousLoading()) {
            nodeEstimation = ImmutableEstimationResult.of(graphProjectConfig.nodeCount(), 0L);
            relationEstimation = ImmutableEstimationResult.of(graphProjectConfig.relationshipCount(), 0L);
        } else {
            CypherQueryEstimator estimator = new CypherQueryEstimator(loadingContext.transactionContext().withRestrictedAccess(AccessMode.Static.READ));
            nodeEstimation = estimator.getNodeEstimation(graphProjectConfig.nodeQuery());
            relationEstimation = estimator.getRelationshipEstimation(graphProjectConfig.relationshipQuery());
        }
        ImmutableGraphDimensions.Builder dimBuilder = ImmutableGraphDimensions.builder();
        baseDimensions.ifPresent(arg_0 -> ((ImmutableGraphDimensions.Builder)dimBuilder).from(arg_0));
        long highestPossibleNodeCount = Math.max(baseDimensions.map(GraphDimensions::highestPossibleNodeCount).orElse(-1L), nodeEstimation.estimatedRows());
        long nodeCount = Math.max(baseDimensions.map(GraphDimensions::nodeCount).orElse(-1L), nodeEstimation.estimatedRows());
        long relCountUpperBound = Math.max(baseDimensions.map(GraphDimensions::relCountUpperBound).orElse(-1L), relationEstimation.estimatedRows());
        GraphDimensions dim = dimBuilder.highestPossibleNodeCount(highestPossibleNodeCount).nodeCount(nodeCount).relCountUpperBound(relCountUpperBound).build();
        return new CypherFactory(graphProjectConfig, loadingContext, dim, nodeEstimation.propertyCount(), relationEstimation.propertyCount());
    }

    private CypherFactory(GraphProjectFromCypherConfig graphProjectConfig, GraphLoaderContext loadingContext, GraphDimensions graphDimensions, long estimatedNumberOfNodeProperties, long estimatedNumberOfRelProperties) {
        super((GraphProjectConfig)graphProjectConfig, (Capabilities)ImmutableStaticCapabilities.of((Capabilities.WriteMode)Capabilities.WriteMode.LOCAL), loadingContext, graphDimensions);
        this.cypherConfig = graphProjectConfig;
        this.numberOfNodeProperties = estimatedNumberOfNodeProperties;
        this.numberOfRelationshipProperties = estimatedNumberOfRelProperties;
        this.progressTracker = this.initProgressTracker();
    }

    protected ProgressTracker progressTracker() {
        return this.progressTracker;
    }

    public MemoryEstimation estimateMemoryUsageDuringLoading() {
        return CSRGraphStoreFactory.getMemoryEstimation((NodeProjections)this.buildEstimateNodeProjections(), (RelationshipProjections)this.buildEstimateRelationshipProjections(), (boolean)true);
    }

    public MemoryEstimation estimateMemoryUsageAfterLoading() {
        return CSRGraphStoreFactory.getMemoryEstimation((NodeProjections)this.buildEstimateNodeProjections(), (RelationshipProjections)this.buildEstimateRelationshipProjections(), (boolean)false);
    }

    public GraphDimensions estimationDimensions() {
        return this.dimensions;
    }

    public CSRGraphStore build() {
        return (CSRGraphStore)this.readOnlyTransaction().apply((tx, ktx) -> {
            BatchLoadResult nodeCount = (BatchLoadResult)new CountingCypherRecordLoader(this.cypherConfig.nodeQuery(), CypherRecordLoader.QueryType.NODE, this.cypherConfig, this.loadingContext).load(ktx.internalTransaction());
            this.progressTracker.beginSubTask("Loading");
            Nodes nodes = (Nodes)new CypherNodeLoader(this.cypherConfig.nodeQuery(), nodeCount.rows(), this.cypherConfig, this.loadingContext, this.progressTracker).load(ktx.internalTransaction());
            RelationshipImportResult relationshipImportResult = (RelationshipImportResult)new CypherRelationshipLoader(this.cypherConfig.relationshipQuery(), nodes.idMap(), this.cypherConfig, this.loadingContext, this.progressTracker).load(ktx.internalTransaction());
            CSRGraphStore graphStore = this.createGraphStore(nodes, relationshipImportResult);
            this.progressTracker.endSubTask("Loading");
            this.logLoadingSummary((GraphStore)graphStore);
            return graphStore;
        });
    }

    private ProgressTracker initProgressTracker() {
        Task task = Tasks.task((String)"Loading", (Task)Tasks.leaf((String)"Nodes", (long)this.dimensions.highestPossibleNodeCount()), (Task[])new Task[]{Tasks.leaf((String)"Relationships", (long)this.dimensions.relCountUpperBound())});
        if (((GraphProjectFromCypherConfig)this.graphProjectConfig).logProgress()) {
            return new TaskProgressTracker(task, this.loadingContext.log(), ((GraphProjectFromCypherConfig)this.graphProjectConfig).readConcurrency(), ((GraphProjectFromCypherConfig)this.graphProjectConfig).jobId(), this.loadingContext.taskRegistryFactory(), (UserLogRegistryFactory)EmptyUserLogRegistryFactory.INSTANCE);
        }
        return new TaskTreeProgressTracker(task, this.loadingContext.log(), ((GraphProjectFromCypherConfig)this.graphProjectConfig).readConcurrency(), ((GraphProjectFromCypherConfig)this.graphProjectConfig).jobId(), this.loadingContext.taskRegistryFactory(), (UserLogRegistryFactory)EmptyUserLogRegistryFactory.INSTANCE);
    }

    private TransactionContext readOnlyTransaction() {
        return this.loadingContext.transactionContext().withRestrictedAccess(AccessMode.Static.READ);
    }

    private NodeProjections buildEstimateNodeProjections() {
        NodeProjection nodeProjection = ((NodeProjection.Builder)NodeProjection.builder().label("*").addAllProperties(CypherFactory.propertyMappings(this.numberOfNodeProperties))).build();
        return NodeProjections.single((NodeLabel)NodeLabel.ALL_NODES, (NodeProjection)nodeProjection);
    }

    private RelationshipProjections buildEstimateRelationshipProjections() {
        RelationshipProjection relationshipProjection = ((RelationshipProjection.Builder)RelationshipProjection.builder().type("*").addAllProperties(CypherFactory.propertyMappings(this.numberOfRelationshipProperties))).build();
        return RelationshipProjections.single((RelationshipType)RelationshipType.ALL_RELATIONSHIPS, (RelationshipProjection)relationshipProjection);
    }

    private static Collection<PropertyMapping> propertyMappings(long propertyCount) {
        return LongStream.range(0L, propertyCount).mapToObj(property -> PropertyMapping.of((String)Long.toString(property), (Object)DefaultValue.DEFAULT)).collect(Collectors.toList());
    }
}

