/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.legacycypherprojection;

import java.util.Locale;
import java.util.Set;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.legacycypherprojection.BatchLoadResult;
import org.neo4j.gds.legacycypherprojection.CypherLoadingUtils;
import org.neo4j.gds.legacycypherprojection.CypherRecordLoader;
import org.neo4j.gds.legacycypherprojection.GraphProjectFromCypherConfig;
import org.neo4j.gds.legacycypherprojection.NodeSubscriber;
import org.neo4j.gds.legacycypherprojection.RelationshipSubscriber;
import org.neo4j.gds.legacycypherprojection.ResultCountingSubscriber;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.QuerySubscription;

class CountingCypherRecordLoader
extends CypherRecordLoader<BatchLoadResult> {
    private final CypherRecordLoader.QueryType queryType;
    private long total;

    CountingCypherRecordLoader(String cypherQuery, CypherRecordLoader.QueryType queryType, GraphProjectFromCypherConfig cypherConfig, GraphLoaderContext loadingContext) {
        super(cypherQuery, -1L, cypherConfig, loadingContext);
        this.queryType = queryType;
    }

    @Override
    BatchLoadResult loadSingleBatch(InternalTransaction tx, int bufferSize) {
        ResultCountingSubscriber subscriber = new ResultCountingSubscriber();
        CypherLoadingUtils.consume((QuerySubscription)this.runLoadingQuery(tx, (QuerySubscriber)subscriber));
        subscriber.error().ifPresent(e -> {
            if (e instanceof AuthorizationViolationException) {
                throw new IllegalArgumentException(String.format(Locale.US, "Query must be read only. Query: [%s]", this.loadQuery));
            }
            throw new RuntimeException((Throwable)e);
        });
        return new BatchLoadResult(subscriber.rows(), -1L);
    }

    @Override
    void updateCounts(BatchLoadResult result) {
        this.total += result.rows();
    }

    @Override
    BatchLoadResult result() {
        return new BatchLoadResult(this.total, -1L);
    }

    @Override
    Set<String> getMandatoryColumns() {
        return this.queryType == CypherRecordLoader.QueryType.NODE ? NodeSubscriber.REQUIRED_COLUMNS : RelationshipSubscriber.REQUIRED_COLUMNS;
    }

    @Override
    Set<String> getReservedColumns() {
        return this.queryType == CypherRecordLoader.QueryType.NODE ? NodeSubscriber.RESERVED_COLUMNS : RelationshipSubscriber.RESERVED_COLUMNS;
    }

    @Override
    CypherRecordLoader.QueryType queryType() {
        return this.queryType;
    }
}

