/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.Postprocessor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.neo4j.gds.doc.syntax.ProcedureLookup;
import org.neo4j.gds.doc.syntax.ProcedureSyntaxAutoChecker;
import org.neo4j.gds.doc.syntax.SyntaxMode;
import org.neo4j.gds.doc.syntax.SyntaxModeMeta;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class SyntaxTestBase {
    private static final Path ASCIIDOC_PATH = Paths.get("asciidoc", new String[0]);
    private Asciidoctor asciidoctor;

    @BeforeEach
    void setUp() {
        this.asciidoctor = Asciidoctor.Factory.create();
    }

    @AfterEach
    void tearDown() {
        this.asciidoctor.shutdown();
    }

    @Test
    void runSyntaxTest(SoftAssertions softAssertions, @TempDir File outputDirectory) {
        this.asciidoctor.javaExtensionRegistry().postprocessor((Postprocessor)this.syntaxPostProcessor(softAssertions));
        File docFile = ASCIIDOC_PATH.resolve(this.adocFile()).toFile();
        Assertions.assertThat((File)docFile).exists().canRead();
        OptionsBuilder options = OptionsBuilder.options().toDir(outputDirectory).safe(SafeMode.UNSAFE);
        this.asciidoctor.convertFile(docFile, options);
        softAssertions.assertAll();
    }

    protected Iterable<SyntaxModeMeta> syntaxModes() {
        return List.of(SyntaxModeMeta.of(SyntaxMode.STREAM), SyntaxModeMeta.of(SyntaxMode.STATS), SyntaxModeMeta.of(SyntaxMode.MUTATE), SyntaxModeMeta.of(SyntaxMode.WRITE));
    }

    protected abstract String adocFile();

    protected List<String> procedurePackages() {
        return List.of("org.neo4j.gds");
    }

    private ProcedureSyntaxAutoChecker syntaxPostProcessor(SoftAssertions syntaxAssertions) {
        ProcedureLookup procedureLookup = ProcedureLookup.forPackages(this.procedurePackages());
        return new ProcedureSyntaxAutoChecker(this.syntaxModes(), syntaxAssertions, procedureLookup);
    }
}

