/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Treeprocessor;
import org.neo4j.gds.doc.ImmutableQueryExample;
import org.neo4j.gds.doc.ImmutableQueryExampleGroup;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.QueryExampleGroup;
import org.neo4j.gds.utils.StringFormatting;

public class QueryCollectingTreeProcessor
extends Treeprocessor {
    private static final String CODE_BLOCK_CONTEXT = ":listing";
    private static final String TABLE_CONTEXT = ":table";
    private static final String SETUP_QUERY_ROLE = "setup-query";
    private static final String GRAPH_CREATE_QUERY_ROLE = "graph-create-query";
    private static final String QUERY_EXAMPLE_ROLE = "query-example";
    private static final String TEST_TYPE_NO_RESULT = "no-result";
    private static final String TEST_GROUP_ATTRIBUTE = "group";
    private static final String ROLE_SELECTOR = "role";
    private List<String> beforeAllQueries;
    private List<String> beforeEachQueries;
    private List<QueryExampleGroup> queryExamples;

    public List<String> beforeAllQueries() {
        return this.beforeAllQueries;
    }

    public List<String> beforeEachQueries() {
        return this.beforeEachQueries;
    }

    public List<QueryExampleGroup> queryExamples() {
        return this.queryExamples;
    }

    public Document process(Document document) {
        this.beforeAllQueries = this.collectBeforeAllQueries((StructuralNode)document);
        this.beforeEachQueries = this.collectBeforeEachQueries((StructuralNode)document);
        this.queryExamples = this.collectQueryExamples((StructuralNode)document);
        return document;
    }

    private List<String> collectBeforeAllQueries(StructuralNode document) {
        return this.collectSetupQueries(document, SETUP_QUERY_ROLE);
    }

    private List<String> collectBeforeEachQueries(StructuralNode document) {
        return this.collectSetupQueries(document, GRAPH_CREATE_QUERY_ROLE);
    }

    private List<String> collectSetupQueries(StructuralNode node, String setupQueryType) {
        List nodes = node.findBy(Map.of(ROLE_SELECTOR, setupQueryType));
        return nodes.stream().map(StructuralNode::getContent).map(Object::toString).map(QueryCollectingTreeProcessor::undoReplacements).collect(Collectors.toList());
    }

    private List<QueryExampleGroup> collectQueryExamples(StructuralNode node) {
        List queryExampleNodes = node.findBy(Map.of(ROLE_SELECTOR, QUERY_EXAMPLE_ROLE));
        HashMap<String, List<StructuralNode>> groupedQueryExampleNodes = this.collectQueryExampleNodes(queryExampleNodes);
        ArrayList<QueryExampleGroup> queryExampleGroups = new ArrayList<QueryExampleGroup>();
        groupedQueryExampleNodes.forEach((displayName, groupedQueryExamples) -> {
            ImmutableQueryExampleGroup.Builder groupBuilder = QueryExampleGroup.builder().displayName((String)displayName);
            groupedQueryExamples.forEach(this.collectQueryExample(groupBuilder));
            queryExampleGroups.add(groupBuilder.build());
        });
        return queryExampleGroups;
    }

    private Consumer<StructuralNode> collectQueryExample(ImmutableQueryExampleGroup.Builder groupBuilder) {
        return queryExampleNode -> {
            StructuralNode codeBlock = this.findByContext((StructuralNode)queryExampleNode, CODE_BLOCK_CONTEXT);
            String query = QueryCollectingTreeProcessor.undoReplacements(codeBlock.getContent().toString());
            ImmutableQueryExample.Builder queryExampleBuilder = QueryExample.builder().query(query);
            if (Boolean.parseBoolean(queryExampleNode.getAttribute((Object)TEST_TYPE_NO_RESULT, (Object)false).toString())) {
                queryExampleBuilder.assertResults(false);
            } else {
                Table resultsTable = (Table)this.findByContext((StructuralNode)queryExampleNode, TABLE_CONTEXT);
                List<String> resultColumns = ((Row)resultsTable.getHeader().get(0)).getCells().stream().map(Cell::getText).collect(Collectors.toList());
                queryExampleBuilder.resultColumns(resultColumns);
                List body = resultsTable.getBody();
                for (Row resultRow : body) {
                    queryExampleBuilder.addResult(resultRow.getCells().stream().map(Cell::getText).map(QueryCollectingTreeProcessor::undoReplacements).collect(Collectors.toList()));
                }
            }
            groupBuilder.addQueryExample(queryExampleBuilder.build());
        };
    }

    private HashMap<String, List<StructuralNode>> collectQueryExampleNodes(Iterable<StructuralNode> queryExampleNodes) {
        HashMap<String, List<StructuralNode>> groupedQueryExampleNodes = new HashMap<String, List<StructuralNode>>();
        queryExampleNodes.forEach(queryExampleNode -> {
            String testDisplayName = this.extractDisplayName((StructuralNode)queryExampleNode);
            groupedQueryExampleNodes.putIfAbsent(testDisplayName, new ArrayList());
            ((List)groupedQueryExampleNodes.get(testDisplayName)).add(queryExampleNode);
        });
        return groupedQueryExampleNodes;
    }

    private String extractDisplayName(StructuralNode queryExampleNode) {
        Object testGroupAttribute = queryExampleNode.getAttribute((Object)TEST_GROUP_ATTRIBUTE);
        if (testGroupAttribute != null) {
            return testGroupAttribute.toString();
        }
        StructuralNode codeBlock = this.findByContext(queryExampleNode, CODE_BLOCK_CONTEXT);
        String query = QueryCollectingTreeProcessor.undoReplacements(codeBlock.getContent().toString());
        return codeBlock.getTitle() == null ? query : codeBlock.getTitle();
    }

    private StructuralNode findByContext(StructuralNode node, String context) {
        return (StructuralNode)node.findBy(Map.of("context", context)).stream().findFirst().orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No nodes found for context '%s'", (Object[])new Object[]{context})));
    }

    private static String undoReplacements(String content) {
        return content.replace("&gt;", ">").replace("&lt;", "<");
    }
}

