/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.Treeprocessor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.util.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.io.TempDir;
import org.neo4j.gds.BaseProcTest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.doc.QueryCollectingTreeProcessor;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.QueryExampleGroup;
import org.neo4j.values.storable.Values;

public abstract class DocTestBase
extends BaseProcTest {
    @TempDir
    File workDir;
    private static final Path ASCIIDOC_PATH = Paths.get("asciidoc", new String[0]);
    private List<String> beforeEachQueries;
    private List<String> beforeAllQueries;
    private List<QueryExampleGroup> queryExampleGroups;

    protected abstract String adocFile();

    protected abstract List<Class<?>> procedures();

    @BeforeEach
    void setUp() throws Exception {
        Class[] clazzArray = new Class[]{};
        this.registerProcedures(this.procedures().toArray(clazzArray));
        this.registerFunctions(this.functions().toArray(clazzArray));
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        QueryCollectingTreeProcessor treeProcessor = new QueryCollectingTreeProcessor();
        asciidoctor.javaExtensionRegistry().treeprocessor((Treeprocessor)treeProcessor);
        File docFile = ASCIIDOC_PATH.resolve(this.adocFile()).toFile();
        Assertions.assertThat((File)docFile).exists().canRead();
        OptionsBuilder options = OptionsBuilder.options().toDir(this.workDir).safe(SafeMode.UNSAFE);
        asciidoctor.convertFile(docFile, options);
        this.beforeEachQueries = treeProcessor.beforeEachQueries();
        this.queryExampleGroups = treeProcessor.queryExamples();
        this.beforeAllQueries = treeProcessor.beforeAllQueries();
        if (!this.setupNeo4jGraphPerTest()) {
            this.beforeAllQueries.forEach(arg_0 -> ((DocTestBase)this).runQuery(arg_0));
        }
    }

    @TestFactory
    Collection<DynamicTest> runTests() {
        return this.queryExampleGroups.stream().map(this::createDynamicTest).collect(Collectors.toList());
    }

    boolean setupNeo4jGraphPerTest() {
        return false;
    }

    private void beforeEachTest() {
        if (this.setupNeo4jGraphPerTest()) {
            this.beforeAllQueries.forEach(x$0 -> super.runQuery(x$0));
        }
        this.beforeEachQueries.forEach(arg_0 -> ((DocTestBase)this).runQuery(arg_0));
    }

    private DynamicTest createDynamicTest(QueryExampleGroup queryExampleGroup) {
        return DynamicTest.dynamicTest((String)queryExampleGroup.displayName(), () -> {
            try {
                this.beforeEachTest();
                queryExampleGroup.queryExamples().forEach(this::runQueryExample);
            }
            finally {
                this.cleanup().run();
            }
        });
    }

    List<Class<?>> functions() {
        return List.of();
    }

    Runnable cleanup() {
        return GraphStoreCatalog::removeAllLoadedGraphs;
    }

    private void runQueryExample(QueryExample queryExample) {
        if (queryExample.assertResults()) {
            this.runQueryExampleAndAssertResults(queryExample);
        } else {
            Assertions.assertThatNoException().isThrownBy(() -> this.runQuery(queryExample.query()));
        }
    }

    private void runQueryExampleAndAssertResults(QueryExample queryExample) {
        this.runQueryWithResultConsumer(queryExample.query(), result -> {
            Assertions.assertThat(queryExample.resultColumns()).containsExactlyElementsOf((Iterable)result.columns());
            ArrayList actualResults = new ArrayList();
            while (result.hasNext()) {
                Map actualResultRow = result.next();
                List actualResultValues = queryExample.resultColumns().stream().map(column -> this.valueToString(actualResultRow.get(column))).collect(Collectors.toList());
                actualResults.add(actualResultValues);
            }
            ((ListAssert)Assertions.assertThat(actualResults).as(queryExample.query(), new Object[0])).containsExactlyElementsOf(queryExample.results());
        });
    }

    private String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (Arrays.isArray((Object)value)) {
            return Values.of((Object)value).prettyPrint();
        }
        return value.toString();
    }
}

