/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;

final class ProcedureLookup {
    private static final List<String> PACKAGES_TO_SCAN = List.of("org.neo4j.gds");
    private final List<Method> procedureMethods = PACKAGES_TO_SCAN.stream().map(this::createReflections).map(r -> r.getMethodsAnnotatedWith(Procedure.class)).flatMap(Collection::stream).collect(Collectors.toList());
    private static final ProcedureLookup INSTANCE = new ProcedureLookup();

    private ProcedureLookup() {
    }

    private Method findProcedureMethod(String fullyQualifiedProcedureName) {
        return this.procedureMethods.stream().filter(method -> {
            Procedure annotation = method.getAnnotation(Procedure.class);
            return annotation.name().equals(fullyQualifiedProcedureName) || annotation.value().equals(fullyQualifiedProcedureName);
        }).findFirst().orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unknown procedure: `%s`", (Object[])new Object[]{fullyQualifiedProcedureName})));
    }

    static Class<?> findResultType(String fullyQualifiedProcedureName) {
        Method method = INSTANCE.findProcedureMethod(fullyQualifiedProcedureName);
        ParameterizedType resultType = (ParameterizedType)method.getGenericReturnType();
        Type actualTypeArgument = resultType.getActualTypeArguments()[0];
        if (actualTypeArgument instanceof Class) {
            return (Class)actualTypeArgument;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Can't find result class for %s", (Object[])new Object[]{fullyQualifiedProcedureName}));
    }

    static List<String> findArgumentNames(String fullyQualifiedProcedureName) {
        Method method = INSTANCE.findProcedureMethod(fullyQualifiedProcedureName);
        Parameter[] parameters = method.getParameters();
        ArrayList<String> result = new ArrayList<String>(parameters.length);
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Name.class)) {
                result.add(parameter.getAnnotation(Name.class).value());
                continue;
            }
            result.add(parameter.getName());
        }
        return result;
    }

    private Reflections createReflections(String pkg) {
        return new Reflections(pkg, new Scanner[]{new MethodAnnotationsScanner()});
    }
}

