/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.doc;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Treeprocessor;

public class AppendixAProcedureListingProcessor
extends Treeprocessor {
    private static final String PROCEDURE_LISTING_ROLE = "procedure-listing";
    private final List<String> procedures = new LinkedList<String>();

    public Document process(Document document) {
        this.extractProcedures((StructuralNode)document);
        return document;
    }

    private void extractProcedures(StructuralNode document) {
        List<Table> tables = this.findProcedureListings(document);
        tables.forEach(table -> table.getBody().forEach(row -> {
            Cell cell = this.getProcedureListingCell((Row)row);
            String procedureName = this.getProcedureName(cell);
            this.procedures.add(procedureName);
        }));
    }

    private String getProcedureName(Cell cell) {
        return cell.getContent().toString().replaceAll("<[^>]*>|\\[\"|\"]", "");
    }

    private Cell getProcedureListingCell(Row row) {
        List cells = row.getCells();
        Cell cell = cells.size() == 2 ? (Cell)cells.get(1) : (Cell)cells.get(0);
        return cell;
    }

    private List<Table> findProcedureListings(StructuralNode document) {
        return document.getBlocks().stream().flatMap(it -> it.getBlocks().stream()).filter(it -> it instanceof Table).filter(it -> it.getRoles().contains(PROCEDURE_LISTING_ROLE)).map(it -> (Table)it).collect(Collectors.toList());
    }

    List<String> procedures() {
        return this.procedures;
    }
}

