/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.doc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Treeprocessor;
import org.neo4j.graphalgo.utils.StringFormatting;

public class QueryConsumingTreeProcessor
extends Treeprocessor {
    private static final String CODE_BLOCK_CONTEXT = ":listing";
    private static final String TABLE_CONTEXT = ":table";
    private static final String SETUP_QUERY_ROLE = "setup-query";
    private static final String GRAPH_CREATE_QUERY_ROLE = "graph-create-query";
    private static final String QUERY_EXAMPLE_ROLE = "query-example";
    private static final String TEST_TYPE_NO_RESULT = "no-result";
    private static final String TEST_GROUP_ATTRIBUTE = "group";
    private static final String ROLE_SELECTOR = "role";
    private final SetupQueryConsumer setupQueryConsumer;
    private final QueryExampleConsumer queryExampleConsumer;
    private final QueryExampleNoResultConsumer queryExampleNoResultConsumer;
    private final Runnable cleanup;
    private List<String> graphCreateQueries;

    public QueryConsumingTreeProcessor(SetupQueryConsumer setupQueryConsumer, QueryExampleConsumer queryExampleConsumer, QueryExampleNoResultConsumer queryExampleNoResultConsumer, Runnable cleanup) {
        this.setupQueryConsumer = setupQueryConsumer;
        this.queryExampleConsumer = queryExampleConsumer;
        this.queryExampleNoResultConsumer = queryExampleNoResultConsumer;
        this.cleanup = cleanup;
        this.graphCreateQueries = new ArrayList<String>();
    }

    public Document process(Document document) {
        this.consumeSetupQueries(document);
        this.graphCreateQueries = this.collectSetupQueries((StructuralNode)document, GRAPH_CREATE_QUERY_ROLE);
        this.consumeQueryExamples((StructuralNode)document);
        return document;
    }

    private void consumeSetupQueries(Document document) {
        List<String> setupQueries = this.collectSetupQueries((StructuralNode)document, SETUP_QUERY_ROLE);
        this.setupQueryConsumer.consume(setupQueries);
    }

    private List<String> collectSetupQueries(StructuralNode node, String setupQueryType) {
        List nodes = node.findBy(Map.of(ROLE_SELECTOR, setupQueryType));
        return nodes.stream().map(StructuralNode::getContent).map(Object::toString).map(this::undoReplacements).collect(Collectors.toList());
    }

    private void consumeQueryExamples(StructuralNode node) {
        ArrayList<StructuralNode> queryExamples = new ArrayList<StructuralNode>();
        ArrayList<StructuralNode> queryNoResultExamples = new ArrayList<StructuralNode>();
        HashMap<String, List<StructuralNode>> groupedQueryExamples = new HashMap<String, List<StructuralNode>>();
        this.collectQueryExamples(node, queryExamples, queryNoResultExamples, groupedQueryExamples);
        queryExamples.forEach(q -> this.processExample(() -> this.processCypherExample((StructuralNode)q)));
        queryNoResultExamples.forEach(q -> this.processExample(() -> this.processCypherNoResultExample((StructuralNode)q)));
        this.processGroupedQueryExamples(groupedQueryExamples);
    }

    private void collectQueryExamples(StructuralNode node, Collection<StructuralNode> queryExamples, Collection<StructuralNode> queryNoResultExamples, Map<String, List<StructuralNode>> groupedQueryExamples) {
        List allQueryExamples = node.findBy(Map.of(ROLE_SELECTOR, QUERY_EXAMPLE_ROLE));
        allQueryExamples.forEach(queryExample -> {
            Object testGroupAttribute = queryExample.getAttribute((Object)TEST_GROUP_ATTRIBUTE);
            if (testGroupAttribute != null) {
                String testGroup = testGroupAttribute.toString();
                groupedQueryExamples.putIfAbsent(testGroup, new ArrayList());
                ((List)groupedQueryExamples.get(testGroup)).add(queryExample);
            } else if (this.isNoResultExample((ContentNode)queryExample)) {
                queryNoResultExamples.add((StructuralNode)queryExample);
            } else {
                queryExamples.add((StructuralNode)queryExample);
            }
        });
    }

    private void processGroupedQueryExamples(Map<String, List<StructuralNode>> groupedQueryExamples) {
        groupedQueryExamples.forEach((group, examples) -> {
            ArrayList<Runnable> groupQueries = new ArrayList<Runnable>();
            examples.forEach(example -> {
                if (this.isNoResultExample((ContentNode)example)) {
                    groupQueries.add(() -> this.processCypherNoResultExample((StructuralNode)example));
                } else {
                    groupQueries.add(() -> this.processCypherExample((StructuralNode)example));
                }
            });
            this.processExamples(groupQueries);
        });
    }

    private boolean isNoResultExample(ContentNode example) {
        return example.hasAttribute((Object)TEST_TYPE_NO_RESULT) && Boolean.parseBoolean(example.getAttribute((Object)TEST_TYPE_NO_RESULT).toString());
    }

    private void processExample(Runnable example) {
        this.setupQueryConsumer.consume(this.graphCreateQueries);
        example.run();
        this.cleanup.run();
    }

    private void processExamples(Iterable<Runnable> examples) {
        this.setupQueryConsumer.consume(this.graphCreateQueries);
        examples.forEach(Runnable::run);
        this.cleanup.run();
    }

    private void processCypherExample(StructuralNode cypherExample) {
        Table resultTable = (Table)this.findByContext(cypherExample, TABLE_CONTEXT);
        List<String> headers = resultTable != null ? this.headers(resultTable) : Collections.emptyList();
        List rows = resultTable != null ? resultTable.getBody() : Collections.emptyList();
        this.queryExampleConsumer.consume(this.getCypherQuery(cypherExample), headers, rows);
    }

    private void processCypherNoResultExample(StructuralNode cypherExample) {
        this.queryExampleNoResultConsumer.consume(this.getCypherQuery(cypherExample));
    }

    private String getCypherQuery(StructuralNode cypherExample) {
        return this.undoReplacements(this.findByContext(cypherExample, CODE_BLOCK_CONTEXT).getContent().toString());
    }

    private StructuralNode findByContext(StructuralNode node, String context) {
        return (StructuralNode)node.findBy(Map.of("context", context)).stream().findFirst().orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No nodes found for context '%s'", (Object[])new Object[]{context})));
    }

    private List<String> headers(Table table) {
        return table.getHeader().isEmpty() ? Collections.emptyList() : ((Row)table.getHeader().get(0)).getCells().stream().map(Cell::getText).collect(Collectors.toList());
    }

    private String undoReplacements(String content) {
        return content.replaceAll("&gt;", ">").replaceAll("&lt;", "<");
    }

    @FunctionalInterface
    static interface SetupQueryConsumer {
        public void consume(List<String> var1);
    }

    @FunctionalInterface
    static interface QueryExampleNoResultConsumer {
        public void consume(String var1);
    }

    @FunctionalInterface
    static interface QueryExampleConsumer {
        public void consume(String var1, List<String> var2, List<Row> var3);
    }
}

