/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Treeprocessor;

public class QueryConsumingTreeProcessor
extends Treeprocessor {
    private static final String SETUP_QUERY_ROLE = "setup-query";
    private static final String QUERY_EXAMPLE_ROLE = "query-example";
    private static final String QUERY_EXAMPLE_NO_RESULT_ROLE = "query-example-no-result";
    private final SetupQueryConsumer setupQueryConsumer;
    private final QueryExampleConsumer queryExampleConsumer;
    private final QueryExampleNoResultConsumer queryExampleNoResultConsumer;

    public QueryConsumingTreeProcessor(SetupQueryConsumer setupQueryConsumer, QueryExampleConsumer queryExampleConsumer, QueryExampleNoResultConsumer queryExampleNoResultConsumer) {
        this.setupQueryConsumer = setupQueryConsumer;
        this.queryExampleConsumer = queryExampleConsumer;
        this.queryExampleNoResultConsumer = queryExampleNoResultConsumer;
    }

    public Document process(Document document) {
        this.consumeSetupQueries(document);
        this.consumeQueryExamples((StructuralNode)document);
        return document;
    }

    private void consumeSetupQueries(Document document) {
        ArrayList<String> setupQueries = new ArrayList<String>();
        this.collectSetupQueries((StructuralNode)document, setupQueries);
        this.setupQueryConsumer.consume(setupQueries);
    }

    private void collectSetupQueries(StructuralNode node, List<String> setupQueries) {
        node.getBlocks().stream().filter(block -> block instanceof StructuralNode).forEach(it -> {
            if (it.getRoles().contains(SETUP_QUERY_ROLE)) {
                setupQueries.add(this.undoReplacements(it.getContent().toString()));
            } else {
                this.collectSetupQueries((StructuralNode)it, setupQueries);
            }
        });
    }

    private void consumeQueryExamples(StructuralNode node) {
        node.getBlocks().forEach(it -> {
            if (it.getRoles().contains(QUERY_EXAMPLE_ROLE)) {
                this.processCypherExample((StructuralNode)it);
            } else if (it.getRoles().contains(QUERY_EXAMPLE_NO_RESULT_ROLE)) {
                this.processCypherNoResultExample((StructuralNode)it);
            } else {
                this.consumeQueryExamples((StructuralNode)it);
            }
        });
    }

    private void processCypherExample(StructuralNode cypherExample) {
        List blocks = cypherExample.getBlocks();
        Table resultTable = (Table)blocks.get(1);
        List<String> headers = resultTable != null ? this.headers(resultTable) : Collections.emptyList();
        List rows = resultTable != null ? resultTable.getBody() : Collections.emptyList();
        this.queryExampleConsumer.consume(this.getCypherQuery(cypherExample), headers, rows);
    }

    private void processCypherNoResultExample(StructuralNode cypherExample) {
        this.queryExampleNoResultConsumer.consume(this.getCypherQuery(cypherExample));
    }

    private String getCypherQuery(StructuralNode cypherExample) {
        return this.undoReplacements(((StructuralNode)cypherExample.getBlocks().get(0)).getContent().toString());
    }

    private List<String> headers(Table table) {
        return table.getHeader().isEmpty() ? Collections.emptyList() : ((Row)table.getHeader().get(0)).getCells().stream().map(Cell::getText).collect(Collectors.toList());
    }

    private String undoReplacements(String content) {
        return content.replaceAll("&gt;", ">").replaceAll("&lt;", "<");
    }

    @FunctionalInterface
    static interface SetupQueryConsumer {
        public void consume(List<String> var1);
    }

    @FunctionalInterface
    static interface QueryExampleNoResultConsumer {
        public void consume(String var1);
    }

    @FunctionalInterface
    static interface QueryExampleConsumer {
        public void consume(String var1, List<String> var2, List<Row> var3);
    }

    static class Testable {
        private final List<String> columns;
        private final List<Row> rows;

        public Testable(List<String> columns, List<Row> rows) {
            this.columns = columns;
            this.rows = rows;
        }

        static Testable of(List<String> headers, List<Row> rows) {
            return new Testable(headers, rows);
        }

        List<String> columns() {
            return this.columns;
        }

        List<Row> rows() {
            return this.rows;
        }

        List<Map<String, Object>> toMaps() {
            return this.rows().stream().filter(row -> row.getCells().size() != 1 || !((Cell)row.getCells().get(0)).getText().endsWith("rows")).map(row -> {
                HashMap thing = new HashMap();
                IntStream.range(0, row.getCells().size()).forEach(i -> thing.put(this.columns().get(i), ((Cell)row.getCells().get(i)).getText()));
                return thing;
            }).collect(Collectors.toList());
        }
    }
}

