/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.doc;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class CypherAsciidocTableConverter {
    private CypherAsciidocTableConverter() {
    }

    public static String asciidoc(String cypher) {
        List lines = Arrays.stream(cypher.split(System.lineSeparator())).filter(s -> !s.startsWith("+")).map(l -> {
            int endIndex = l.lastIndexOf(124);
            return endIndex < 0 ? l : l.substring(0, endIndex).trim();
        }).collect(Collectors.toList());
        int columns = ((String)lines.get(0)).split("\\|").length - 1;
        lines.remove(lines.size() - 1);
        lines.add(String.format("%d+|%d rows", columns, lines.size() - 1));
        lines.add("");
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    public static String cypher(String asciidoc) {
        Deque lines = Arrays.stream(asciidoc.split(System.lineSeparator())).collect(Collectors.toCollection(ArrayDeque::new));
        Optional<Integer> maxWidth = lines.stream().map(String::length).max(Integer::compare);
        int w = maxWidth.get();
        String separator = CypherAsciidocTableConverter.separator(w);
        String rowCountLine = (String)lines.getLast();
        lines.removeLast();
        ArrayList<String> result = new ArrayList<String>();
        result.add(separator);
        result.add(CypherAsciidocTableConverter.pad((String)lines.pop(), w));
        result.add(separator);
        while (!lines.isEmpty()) {
            result.add(CypherAsciidocTableConverter.pad((String)lines.pop(), w));
        }
        result.add(separator);
        result.add(rowCountLine.split("\\|")[1]);
        result.add("");
        return String.join((CharSequence)System.lineSeparator(), result);
    }

    public static String separator(int w) {
        StringBuilder sb = new StringBuilder().append("+");
        for (int i = 0; i < w; ++i) {
            sb.append("-");
        }
        return sb.append("+").toString();
    }

    public static String pad(String s, int w) {
        StringBuilder sb = new StringBuilder().append(s);
        for (int i = 0; i < w - (s.length() - 1); ++i) {
            sb.append(" ");
        }
        sb.append("|");
        return sb.toString();
    }
}

