/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.doc.syntax.SyntaxMode;
import org.neo4j.gds.doc.syntax.SyntaxModeMeta;

@ParametersAreNonnullByDefault
@Generated(from="SyntaxModeMeta", generator="Immutables")
@Immutable
public final class ImmutableSyntaxModeMeta
implements SyntaxModeMeta {
    private final SyntaxMode syntaxMode;
    private final int sectionsOnPage;

    private ImmutableSyntaxModeMeta(SyntaxMode syntaxMode, int sectionsOnPage) {
        this.syntaxMode = Objects.requireNonNull(syntaxMode, "syntaxMode");
        this.sectionsOnPage = sectionsOnPage;
    }

    private ImmutableSyntaxModeMeta(ImmutableSyntaxModeMeta original, SyntaxMode syntaxMode, int sectionsOnPage) {
        this.syntaxMode = syntaxMode;
        this.sectionsOnPage = sectionsOnPage;
    }

    @Override
    public SyntaxMode syntaxMode() {
        return this.syntaxMode;
    }

    @Override
    public int sectionsOnPage() {
        return this.sectionsOnPage;
    }

    public final ImmutableSyntaxModeMeta withSyntaxMode(SyntaxMode value) {
        SyntaxMode newValue = Objects.requireNonNull(value, "syntaxMode");
        if (this.syntaxMode == newValue) {
            return this;
        }
        return new ImmutableSyntaxModeMeta(this, newValue, this.sectionsOnPage);
    }

    public final ImmutableSyntaxModeMeta withSectionsOnPage(int value) {
        if (this.sectionsOnPage == value) {
            return this;
        }
        return new ImmutableSyntaxModeMeta(this, this.syntaxMode, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSyntaxModeMeta && this.equalTo(0, (ImmutableSyntaxModeMeta)another);
    }

    private boolean equalTo(int synthetic, ImmutableSyntaxModeMeta another) {
        return this.syntaxMode.equals((Object)another.syntaxMode) && this.sectionsOnPage == another.sectionsOnPage;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.syntaxMode.hashCode();
        h += (h << 5) + this.sectionsOnPage;
        return h;
    }

    public String toString() {
        return "SyntaxModeMeta{syntaxMode=" + this.syntaxMode + ", sectionsOnPage=" + this.sectionsOnPage + "}";
    }

    public static SyntaxModeMeta of(SyntaxMode syntaxMode, int sectionsOnPage) {
        return new ImmutableSyntaxModeMeta(syntaxMode, sectionsOnPage);
    }

    public static SyntaxModeMeta copyOf(SyntaxModeMeta instance) {
        if (instance instanceof ImmutableSyntaxModeMeta) {
            return (ImmutableSyntaxModeMeta)instance;
        }
        return ImmutableSyntaxModeMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SyntaxModeMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SYNTAX_MODE = 1L;
        private static final long INIT_BIT_SECTIONS_ON_PAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private SyntaxMode syntaxMode;
        private int sectionsOnPage;

        private Builder() {
        }

        public final Builder from(SyntaxModeMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.syntaxMode(instance.syntaxMode());
            this.sectionsOnPage(instance.sectionsOnPage());
            return this;
        }

        public final Builder syntaxMode(SyntaxMode syntaxMode) {
            this.syntaxMode = Objects.requireNonNull(syntaxMode, "syntaxMode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sectionsOnPage(int sectionsOnPage) {
            this.sectionsOnPage = sectionsOnPage;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.syntaxMode = null;
            this.sectionsOnPage = 0;
            return this;
        }

        public SyntaxModeMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSyntaxModeMeta(null, this.syntaxMode, this.sectionsOnPage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("syntaxMode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sectionsOnPage");
            }
            return "Cannot build SyntaxModeMeta, some of required attributes are not set " + attributes;
        }
    }
}

