/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.Treeprocessor;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ListAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.io.TempDir;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.gds.QueryRunner;
import org.neo4j.gds.compat.CompatUserAggregationFunction;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.doc.DocumentationTestToolsConstants;
import org.neo4j.gds.doc.PartialsIncludeProcessor;
import org.neo4j.gds.doc.QueryCollectingTreeProcessor;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.QueryExampleGroup;
import org.neo4j.gds.doc.syntax.DocQuery;
import org.neo4j.gds.settings.Neo4jSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;

public abstract class MultiFileDocTestBase {
    private List<DocQuery> beforeEachQueries;
    private List<DocQuery> beforeAllQueries;
    private List<QueryExampleGroup> queryExampleGroups;
    @Inject
    protected DatabaseManagementService dbms;
    protected GraphDatabaseService defaultDb;

    protected abstract List<String> adocPaths();

    @BeforeEach
    void setUp(@TempDir File workingDirectory) throws Exception {
        this.dbms = this.setupDbms(workingDirectory.toPath());
        this.defaultDb = this.dbms.database("neo4j");
        Class[] clazzArray = new Class[]{};
        GraphDatabaseService defaultDb = this.dbms.database("neo4j");
        GraphDatabaseApiProxy.registerProcedures((GraphDatabaseService)defaultDb, (Class[])this.procedures().toArray(clazzArray));
        GraphDatabaseApiProxy.registerFunctions((GraphDatabaseService)defaultDb, (Class[])this.functions().toArray(clazzArray));
        for (CompatUserAggregationFunction func : this.aggregationFunctions()) {
            GraphDatabaseApiProxy.register((GraphDatabaseService)defaultDb, (CallableUserAggregationFunction)Neo4jProxy.callableUserAggregationFunction((CompatUserAggregationFunction)func));
        }
        QueryCollectingTreeProcessor treeProcessor = new QueryCollectingTreeProcessor();
        PartialsIncludeProcessor includeProcessor = new PartialsIncludeProcessor();
        try (Asciidoctor asciidoctor = Asciidoctor.Factory.create();){
            asciidoctor.javaExtensionRegistry().includeProcessor((IncludeProcessor)includeProcessor).treeprocessor((Treeprocessor)treeProcessor);
            OptionsBuilder options = Options.builder().toDir(workingDirectory).safe(SafeMode.UNSAFE);
            for (File docFile : this.adocFiles()) {
                asciidoctor.convertFile(docFile, options.build());
            }
        }
        this.beforeEachQueries = treeProcessor.getBeforeEachQueries();
        this.queryExampleGroups = treeProcessor.getQueryExampleGroups();
        this.beforeAllQueries = treeProcessor.getBeforeAllQueries();
        if (!this.setupNeo4jGraphPerTest()) {
            this.beforeAllQueries.forEach(this::runDocQuery);
        }
    }

    @AfterEach
    void tearDownDbms() {
        this.dbms.shutdown();
    }

    protected DatabaseManagementService setupDbms(Path workingDirectory) {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(Neo4jLayout.of((Path)workingDirectory));
        this.configureDbms(builder);
        return builder.build();
    }

    protected void configureDbms(TestDatabaseManagementServiceBuilder builder) {
        builder.noOpSystemGraphInitializer();
        builder.setConfig(Neo4jSettings.procedureUnrestricted(), Collections.singletonList("gds.*"));
    }

    private List<File> adocFiles() {
        return this.adocPaths().stream().map(DocumentationTestToolsConstants.ASCIIDOC_PATH::resolve).map(Path::toFile).collect(Collectors.toList());
    }

    @TestFactory
    Collection<DynamicTest> runTests() {
        ((ListAssert)Assertions.assertThat(this.queryExampleGroups).as("Query Example Groups should not be empty!", new Object[0])).isNotEmpty();
        return this.queryExampleGroups.stream().map(this::createDynamicTest).collect(Collectors.toList());
    }

    boolean setupNeo4jGraphPerTest() {
        return false;
    }

    private void beforeEachTest() {
        if (this.setupNeo4jGraphPerTest()) {
            this.beforeAllQueries.forEach(this::runDocQuery);
        }
        this.beforeEachQueries.forEach(this::runDocQuery);
    }

    private void runDocQuery(DocQuery docQuery) {
        try {
            if (docQuery.runAsOperator()) {
                QueryRunner.runQuery((GraphDatabaseService)this.dbms.database(docQuery.database()), (String)docQuery.operator(), (String)docQuery.query(), Map.of());
            } else {
                QueryRunner.runQuery((GraphDatabaseService)this.dbms.database(docQuery.database()), (String)docQuery.query());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to run query: " + docQuery.query(), e);
        }
    }

    private DynamicTest createDynamicTest(QueryExampleGroup queryExampleGroup) {
        return DynamicTest.dynamicTest((String)queryExampleGroup.displayName(), () -> {
            try {
                this.beforeEachTest();
                queryExampleGroup.queryExamples().forEach(this::runQueryExample);
            }
            finally {
                this.cleanup().run();
            }
        });
    }

    private void runQueryExampleWithResultConsumer(QueryExample queryExample, Consumer<Result> check) {
        if (queryExample.runAsOperator()) {
            QueryRunner.runQueryWithResultConsumer((GraphDatabaseService)this.dbms.database(queryExample.database()), (String)queryExample.operator(), (String)queryExample.query(), Map.of(), check);
        } else {
            QueryRunner.runQueryWithResultConsumer((GraphDatabaseService)this.dbms.database(queryExample.database()), (String)queryExample.query(), Map.of(), check);
        }
    }

    private void runQueryExampleAndAssertResults(QueryExample queryExample) {
        this.runQueryExampleWithResultConsumer(queryExample, result -> {
            Assertions.assertThat(queryExample.resultColumns()).containsExactlyElementsOf((Iterable)result.columns());
            ArrayList actualResults = new ArrayList();
            while (result.hasNext()) {
                Map actualResultRow = result.next();
                List actualResultValues = queryExample.resultColumns().stream().map(column -> this.valueToString(actualResultRow.get(column))).collect(Collectors.toList());
                actualResults.add(actualResultValues);
            }
            List<List<String>> expectedResults = this.reducePrecisionOfDoubles(queryExample.results());
            ((ListAssert)Assertions.assertThat(actualResults).as(queryExample.query(), new Object[0])).containsExactlyElementsOf(expectedResults);
        });
    }

    private void runQueryExample(QueryExample queryExample) {
        if (queryExample.assertResults()) {
            this.runQueryExampleAndAssertResults(queryExample);
        } else {
            AssertionsForClassTypes.assertThatNoException().isThrownBy(() -> this.runDocQuery(queryExample));
        }
    }

    protected abstract List<Class<?>> procedures();

    protected List<Class<?>> functions() {
        return List.of();
    }

    protected List<CompatUserAggregationFunction> aggregationFunctions() {
        return List.of();
    }

    Runnable cleanup() {
        return GraphStoreCatalog::removeAllLoadedGraphs;
    }

    private List<List<String>> reducePrecisionOfDoubles(Collection<List<String>> resultsFromDoc) {
        return resultsFromDoc.stream().map(list -> list.stream().map(string -> {
            try {
                if (string.startsWith("[")) {
                    return MultiFileDocTestBase.formatListOfNumbers(string);
                }
                if (string.contains(".")) {
                    return DocumentationTestToolsConstants.FLOAT_FORMAT.format(Double.parseDouble(string));
                }
                return string;
            }
            catch (NumberFormatException e) {
                return string;
            }
        }).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @NotNull
    private static String formatListOfNumbers(String string) {
        String withoutBrackets = string.substring(1, string.length() - 1);
        String commaSeparator = ", ";
        String[] parts = withoutBrackets.split(commaSeparator);
        StringBuilder builder = new StringBuilder("[");
        String separator = "";
        for (String part : parts) {
            builder.append(separator);
            String formattedPart = part.contains(".") ? DocumentationTestToolsConstants.FLOAT_FORMAT.format(Double.parseDouble(part)) : part;
            builder.append(formattedPart);
            separator = commaSeparator;
        }
        builder.append("]");
        return builder.toString();
    }

    private String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Double || value instanceof Float) {
            return DocumentationTestToolsConstants.FLOAT_FORMAT.format(value);
        }
        if (value instanceof List) {
            return ((List)value).stream().map(v -> this.valueToString(v)).collect(Collectors.toList()).toString();
        }
        if (value instanceof Map) {
            Map<String, String> mappedMap = ((Map)value).entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> this.valueToString(entry.getValue())));
            return new TreeMap<String, String>(mappedMap).toString();
        }
        return value.toString();
    }
}

