/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.QueryExampleGroup;

@ParametersAreNonnullByDefault
@Generated(from="QueryExampleGroup", generator="Immutables")
@Immutable
public final class ImmutableQueryExampleGroup
implements QueryExampleGroup {
    private final String displayName;
    private final List<QueryExample> queryExamples;

    private ImmutableQueryExampleGroup(String displayName, Iterable<? extends QueryExample> queryExamples) {
        this.displayName = Objects.requireNonNull(displayName, "displayName");
        this.queryExamples = ImmutableQueryExampleGroup.createUnmodifiableList(false, ImmutableQueryExampleGroup.createSafeList(queryExamples, true, false));
    }

    private ImmutableQueryExampleGroup(ImmutableQueryExampleGroup original, String displayName, List<QueryExample> queryExamples) {
        this.displayName = displayName;
        this.queryExamples = queryExamples;
    }

    @Override
    public String displayName() {
        return this.displayName;
    }

    @Override
    public List<QueryExample> queryExamples() {
        return this.queryExamples;
    }

    public final ImmutableQueryExampleGroup withDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "displayName");
        if (this.displayName.equals(newValue)) {
            return this;
        }
        return new ImmutableQueryExampleGroup(this, newValue, this.queryExamples);
    }

    public final ImmutableQueryExampleGroup withQueryExamples(QueryExample ... elements) {
        List<QueryExample> newValue = ImmutableQueryExampleGroup.createUnmodifiableList(false, ImmutableQueryExampleGroup.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableQueryExampleGroup(this, this.displayName, newValue);
    }

    public final ImmutableQueryExampleGroup withQueryExamples(Iterable<? extends QueryExample> elements) {
        if (this.queryExamples == elements) {
            return this;
        }
        List<QueryExample> newValue = ImmutableQueryExampleGroup.createUnmodifiableList(false, ImmutableQueryExampleGroup.createSafeList(elements, true, false));
        return new ImmutableQueryExampleGroup(this, this.displayName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryExampleGroup && this.equalTo(0, (ImmutableQueryExampleGroup)another);
    }

    private boolean equalTo(int synthetic, ImmutableQueryExampleGroup another) {
        return this.displayName.equals(another.displayName) && this.queryExamples.equals(another.queryExamples);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + this.queryExamples.hashCode();
        return h;
    }

    public String toString() {
        return "QueryExampleGroup{displayName=" + this.displayName + ", queryExamples=" + this.queryExamples + "}";
    }

    public static QueryExampleGroup of(String displayName, List<QueryExample> queryExamples) {
        return ImmutableQueryExampleGroup.of(displayName, queryExamples);
    }

    public static QueryExampleGroup of(String displayName, Iterable<? extends QueryExample> queryExamples) {
        return new ImmutableQueryExampleGroup(displayName, queryExamples);
    }

    public static QueryExampleGroup copyOf(QueryExampleGroup instance) {
        if (instance instanceof ImmutableQueryExampleGroup) {
            return (ImmutableQueryExampleGroup)instance;
        }
        return ImmutableQueryExampleGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="QueryExampleGroup", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DISPLAY_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String displayName;
        private List<QueryExample> queryExamples = null;

        private Builder() {
        }

        public final Builder from(QueryExampleGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.displayName(instance.displayName());
            this.addAllQueryExamples(instance.queryExamples());
            return this;
        }

        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addQueryExample(QueryExample element) {
            if (this.queryExamples == null) {
                this.queryExamples = new ArrayList<QueryExample>();
            }
            this.queryExamples.add(Objects.requireNonNull(element, "queryExamples element"));
            return this;
        }

        public final Builder addQueryExamples(QueryExample ... elements) {
            if (this.queryExamples == null) {
                this.queryExamples = new ArrayList<QueryExample>();
            }
            for (QueryExample element : elements) {
                this.queryExamples.add(Objects.requireNonNull(element, "queryExamples element"));
            }
            return this;
        }

        public final Builder queryExamples(Iterable<? extends QueryExample> elements) {
            this.queryExamples = new ArrayList<QueryExample>();
            return this.addAllQueryExamples(elements);
        }

        public final Builder addAllQueryExamples(Iterable<? extends QueryExample> elements) {
            Objects.requireNonNull(elements, "queryExamples element");
            if (this.queryExamples == null) {
                this.queryExamples = new ArrayList<QueryExample>();
            }
            for (QueryExample queryExample : elements) {
                this.queryExamples.add(Objects.requireNonNull(queryExample, "queryExamples element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.displayName = null;
            if (this.queryExamples != null) {
                this.queryExamples.clear();
            }
            return this;
        }

        public QueryExampleGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryExampleGroup(null, this.displayName, this.queryExamples == null ? Collections.emptyList() : ImmutableQueryExampleGroup.createUnmodifiableList(true, this.queryExamples));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("displayName");
            }
            return "Cannot build QueryExampleGroup, some of required attributes are not set " + attributes;
        }
    }
}

