/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.syntax.DocQuery;

@ParametersAreNonnullByDefault
@Generated(from="QueryExample", generator="Immutables")
@Immutable
public final class ImmutableQueryExample
implements QueryExample {
    private final String database;
    private final String query;
    private final List<String> resultColumns;
    private final List<List<String>> results;
    private final boolean assertResults;
    private final transient boolean runAsOperator;
    private final String operator;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableQueryExample(String database, String query, Iterable<String> resultColumns, Iterable<? extends List<String>> results, boolean assertResults, String operator) {
        this.initShim.database(Objects.requireNonNull(database, "database"));
        this.query = Objects.requireNonNull(query, "query");
        this.initShim.resultColumns(ImmutableQueryExample.createUnmodifiableList(false, ImmutableQueryExample.createSafeList(resultColumns, true, false)));
        this.initShim.results(ImmutableQueryExample.createUnmodifiableList(false, ImmutableQueryExample.createSafeList(results, true, false)));
        this.initShim.assertResults(assertResults);
        this.initShim.operator(Objects.requireNonNull(operator, "operator"));
        this.database = this.initShim.database();
        this.resultColumns = this.initShim.resultColumns();
        this.results = this.initShim.results();
        this.assertResults = this.initShim.assertResults();
        this.runAsOperator = this.initShim.runAsOperator();
        this.operator = this.initShim.operator();
        this.initShim = null;
    }

    private ImmutableQueryExample(Builder builder) {
        this.query = builder.query;
        if (builder.database != null) {
            this.initShim.database(builder.database);
        }
        if (builder.resultColumnsIsSet()) {
            this.initShim.resultColumns(builder.resultColumns == null ? Collections.emptyList() : ImmutableQueryExample.createUnmodifiableList(true, builder.resultColumns));
        }
        if (builder.resultsIsSet()) {
            this.initShim.results(builder.results == null ? Collections.emptyList() : ImmutableQueryExample.createUnmodifiableList(true, builder.results));
        }
        if (builder.assertResultsIsSet()) {
            this.initShim.assertResults(builder.assertResults);
        }
        if (builder.operator != null) {
            this.initShim.operator(builder.operator);
        }
        this.database = this.initShim.database();
        this.resultColumns = this.initShim.resultColumns();
        this.results = this.initShim.results();
        this.assertResults = this.initShim.assertResults();
        this.runAsOperator = this.initShim.runAsOperator();
        this.operator = this.initShim.operator();
        this.initShim = null;
    }

    private ImmutableQueryExample(ImmutableQueryExample original, String database, String query, List<String> resultColumns, List<List<String>> results, boolean assertResults, String operator) {
        this.initShim.database(database);
        this.query = query;
        this.initShim.resultColumns(resultColumns);
        this.initShim.results(results);
        this.initShim.assertResults(assertResults);
        this.initShim.operator(operator);
        this.database = this.initShim.database();
        this.resultColumns = this.initShim.resultColumns();
        this.results = this.initShim.results();
        this.assertResults = this.initShim.assertResults();
        this.runAsOperator = this.initShim.runAsOperator();
        this.operator = this.initShim.operator();
        this.initShim = null;
    }

    private String databaseInitialize() {
        return QueryExample.super.database();
    }

    private List<String> resultColumnsInitialize() {
        return QueryExample.super.resultColumns();
    }

    private List<List<String>> resultsInitialize() {
        return QueryExample.super.results();
    }

    private boolean assertResultsInitialize() {
        return QueryExample.super.assertResults();
    }

    private boolean runAsOperatorInitialize() {
        return QueryExample.super.runAsOperator();
    }

    private String operatorInitialize() {
        return QueryExample.super.operator();
    }

    @Override
    public String database() {
        InitShim shim = this.initShim;
        return shim != null ? shim.database() : this.database;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public List<String> resultColumns() {
        InitShim shim = this.initShim;
        return shim != null ? shim.resultColumns() : this.resultColumns;
    }

    @Override
    public List<List<String>> results() {
        InitShim shim = this.initShim;
        return shim != null ? shim.results() : this.results;
    }

    @Override
    public boolean assertResults() {
        InitShim shim = this.initShim;
        return shim != null ? shim.assertResults() : this.assertResults;
    }

    @Override
    public boolean runAsOperator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.runAsOperator() : this.runAsOperator;
    }

    @Override
    public String operator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.operator() : this.operator;
    }

    public final ImmutableQueryExample withDatabase(String value) {
        String newValue = Objects.requireNonNull(value, "database");
        if (this.database.equals(newValue)) {
            return this;
        }
        return new ImmutableQueryExample(this, newValue, this.query, this.resultColumns, this.results, this.assertResults, this.operator);
    }

    public final ImmutableQueryExample withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (this.query.equals(newValue)) {
            return this;
        }
        return new ImmutableQueryExample(this, this.database, newValue, this.resultColumns, this.results, this.assertResults, this.operator);
    }

    public final ImmutableQueryExample withResultColumns(String ... elements) {
        List<String> newValue = ImmutableQueryExample.createUnmodifiableList(false, ImmutableQueryExample.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableQueryExample(this, this.database, this.query, newValue, this.results, this.assertResults, this.operator);
    }

    public final ImmutableQueryExample withResultColumns(Iterable<String> elements) {
        if (this.resultColumns == elements) {
            return this;
        }
        List<String> newValue = ImmutableQueryExample.createUnmodifiableList(false, ImmutableQueryExample.createSafeList(elements, true, false));
        return new ImmutableQueryExample(this, this.database, this.query, newValue, this.results, this.assertResults, this.operator);
    }

    @SafeVarargs
    public final ImmutableQueryExample withResults(List<String> ... elements) {
        List<List<String>> newValue = ImmutableQueryExample.createUnmodifiableList(false, ImmutableQueryExample.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableQueryExample(this, this.database, this.query, this.resultColumns, newValue, this.assertResults, this.operator);
    }

    public final ImmutableQueryExample withResults(Iterable<? extends List<String>> elements) {
        if (this.results == elements) {
            return this;
        }
        List<List<String>> newValue = ImmutableQueryExample.createUnmodifiableList(false, ImmutableQueryExample.createSafeList(elements, true, false));
        return new ImmutableQueryExample(this, this.database, this.query, this.resultColumns, newValue, this.assertResults, this.operator);
    }

    public final ImmutableQueryExample withAssertResults(boolean value) {
        if (this.assertResults == value) {
            return this;
        }
        return new ImmutableQueryExample(this, this.database, this.query, this.resultColumns, this.results, value, this.operator);
    }

    public final ImmutableQueryExample withOperator(String value) {
        String newValue = Objects.requireNonNull(value, "operator");
        if (this.operator.equals(newValue)) {
            return this;
        }
        return new ImmutableQueryExample(this, this.database, this.query, this.resultColumns, this.results, this.assertResults, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryExample && this.equalTo(0, (ImmutableQueryExample)another);
    }

    private boolean equalTo(int synthetic, ImmutableQueryExample another) {
        return this.database.equals(another.database) && this.query.equals(another.query) && this.resultColumns.equals(another.resultColumns) && this.results.equals(another.results) && this.assertResults == another.assertResults && this.runAsOperator == another.runAsOperator && this.operator.equals(another.operator);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.database.hashCode();
        h += (h << 5) + this.query.hashCode();
        h += (h << 5) + this.resultColumns.hashCode();
        h += (h << 5) + this.results.hashCode();
        h += (h << 5) + Boolean.hashCode(this.assertResults);
        h += (h << 5) + Boolean.hashCode(this.runAsOperator);
        h += (h << 5) + this.operator.hashCode();
        return h;
    }

    public String toString() {
        return "QueryExample{database=" + this.database + ", query=" + this.query + ", resultColumns=" + this.resultColumns + ", results=" + this.results + ", assertResults=" + this.assertResults + ", runAsOperator=" + this.runAsOperator + ", operator=" + this.operator + "}";
    }

    public static QueryExample of(String database, String query, List<String> resultColumns, List<List<String>> results, boolean assertResults, String operator) {
        return ImmutableQueryExample.of(database, query, resultColumns, results, assertResults, operator);
    }

    public static QueryExample of(String database, String query, Iterable<String> resultColumns, Iterable<? extends List<String>> results, boolean assertResults, String operator) {
        return new ImmutableQueryExample(database, query, resultColumns, results, assertResults, operator);
    }

    public static QueryExample copyOf(QueryExample instance) {
        if (instance instanceof ImmutableQueryExample) {
            return (ImmutableQueryExample)instance;
        }
        return ImmutableQueryExample.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="QueryExample", generator="Immutables")
    private final class InitShim {
        private byte databaseBuildStage = 0;
        private String database;
        private byte resultColumnsBuildStage = 0;
        private List<String> resultColumns;
        private byte resultsBuildStage = 0;
        private List<List<String>> results;
        private byte assertResultsBuildStage = 0;
        private boolean assertResults;
        private byte runAsOperatorBuildStage = 0;
        private boolean runAsOperator;
        private byte operatorBuildStage = 0;
        private String operator;

        private InitShim() {
        }

        String database() {
            if (this.databaseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.databaseBuildStage == 0) {
                this.databaseBuildStage = (byte)-1;
                this.database = Objects.requireNonNull(ImmutableQueryExample.this.databaseInitialize(), "database");
                this.databaseBuildStage = 1;
            }
            return this.database;
        }

        void database(String database) {
            this.database = database;
            this.databaseBuildStage = 1;
        }

        List<String> resultColumns() {
            if (this.resultColumnsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.resultColumnsBuildStage == 0) {
                this.resultColumnsBuildStage = (byte)-1;
                this.resultColumns = ImmutableQueryExample.createUnmodifiableList(false, ImmutableQueryExample.createSafeList(ImmutableQueryExample.this.resultColumnsInitialize(), true, false));
                this.resultColumnsBuildStage = 1;
            }
            return this.resultColumns;
        }

        void resultColumns(List<String> resultColumns) {
            this.resultColumns = resultColumns;
            this.resultColumnsBuildStage = 1;
        }

        List<List<String>> results() {
            if (this.resultsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.resultsBuildStage == 0) {
                this.resultsBuildStage = (byte)-1;
                this.results = ImmutableQueryExample.createUnmodifiableList(false, ImmutableQueryExample.createSafeList(ImmutableQueryExample.this.resultsInitialize(), true, false));
                this.resultsBuildStage = 1;
            }
            return this.results;
        }

        void results(List<List<String>> results) {
            this.results = results;
            this.resultsBuildStage = 1;
        }

        boolean assertResults() {
            if (this.assertResultsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.assertResultsBuildStage == 0) {
                this.assertResultsBuildStage = (byte)-1;
                this.assertResults = ImmutableQueryExample.this.assertResultsInitialize();
                this.assertResultsBuildStage = 1;
            }
            return this.assertResults;
        }

        void assertResults(boolean assertResults) {
            this.assertResults = assertResults;
            this.assertResultsBuildStage = 1;
        }

        boolean runAsOperator() {
            if (this.runAsOperatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.runAsOperatorBuildStage == 0) {
                this.runAsOperatorBuildStage = (byte)-1;
                this.runAsOperator = ImmutableQueryExample.this.runAsOperatorInitialize();
                this.runAsOperatorBuildStage = 1;
            }
            return this.runAsOperator;
        }

        String operator() {
            if (this.operatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.operatorBuildStage == 0) {
                this.operatorBuildStage = (byte)-1;
                this.operator = Objects.requireNonNull(ImmutableQueryExample.this.operatorInitialize(), "operator");
                this.operatorBuildStage = 1;
            }
            return this.operator;
        }

        void operator(String operator) {
            this.operator = operator;
            this.operatorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.databaseBuildStage == -1) {
                attributes.add("database");
            }
            if (this.resultColumnsBuildStage == -1) {
                attributes.add("resultColumns");
            }
            if (this.resultsBuildStage == -1) {
                attributes.add("results");
            }
            if (this.assertResultsBuildStage == -1) {
                attributes.add("assertResults");
            }
            if (this.runAsOperatorBuildStage == -1) {
                attributes.add("runAsOperator");
            }
            if (this.operatorBuildStage == -1) {
                attributes.add("operator");
            }
            return "Cannot build QueryExample, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="QueryExample", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_QUERY = 1L;
        private static final long OPT_BIT_RESULT_COLUMNS = 1L;
        private static final long OPT_BIT_RESULTS = 2L;
        private static final long OPT_BIT_ASSERT_RESULTS = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String database;
        @Nullable
        private String query;
        private List<String> resultColumns = null;
        private List<List<String>> results = null;
        private boolean assertResults;
        @Nullable
        private String operator;

        private Builder() {
        }

        public final Builder from(QueryExample instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(DocQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            DocQuery instance;
            long bits = 0L;
            if (object instanceof QueryExample) {
                instance = (QueryExample)object;
                if ((bits & 4L) == 0L) {
                    this.database(instance.database());
                    bits |= 4L;
                }
                this.addAllResults(instance.results());
                if ((bits & 2L) == 0L) {
                    this.operator(instance.operator());
                    bits |= 2L;
                }
                this.assertResults(instance.assertResults());
                if ((bits & 1L) == 0L) {
                    this.query(instance.query());
                    bits |= 1L;
                }
                this.addAllResultColumns(instance.resultColumns());
            }
            if (object instanceof DocQuery) {
                instance = (DocQuery)object;
                if ((bits & 2L) == 0L) {
                    this.operator(instance.operator());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.database(instance.database());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.query(instance.query());
                    bits |= 1L;
                }
            }
        }

        public final Builder database(String database) {
            this.database = Objects.requireNonNull(database, "database");
            return this;
        }

        public final Builder query(String query) {
            this.query = Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addResultColumn(String element) {
            if (this.resultColumns == null) {
                this.resultColumns = new ArrayList<String>();
            }
            this.resultColumns.add(Objects.requireNonNull(element, "resultColumns element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addResultColumns(String ... elements) {
            if (this.resultColumns == null) {
                this.resultColumns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.resultColumns.add(Objects.requireNonNull(element, "resultColumns element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder resultColumns(Iterable<String> elements) {
            this.resultColumns = new ArrayList<String>();
            return this.addAllResultColumns(elements);
        }

        public final Builder addAllResultColumns(Iterable<String> elements) {
            Objects.requireNonNull(elements, "resultColumns element");
            if (this.resultColumns == null) {
                this.resultColumns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.resultColumns.add(Objects.requireNonNull(element, "resultColumns element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addResult(List<String> element) {
            if (this.results == null) {
                this.results = new ArrayList<List<String>>();
            }
            this.results.add(Objects.requireNonNull(element, "results element"));
            this.optBits |= 2L;
            return this;
        }

        @SafeVarargs
        public final Builder addResults(List<String> ... elements) {
            if (this.results == null) {
                this.results = new ArrayList<List<String>>();
            }
            for (List<String> element : elements) {
                this.results.add(Objects.requireNonNull(element, "results element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder results(Iterable<? extends List<String>> elements) {
            this.results = new ArrayList<List<String>>();
            return this.addAllResults(elements);
        }

        public final Builder addAllResults(Iterable<? extends List<String>> elements) {
            Objects.requireNonNull(elements, "results element");
            if (this.results == null) {
                this.results = new ArrayList<List<String>>();
            }
            for (List<String> list : elements) {
                this.results.add(Objects.requireNonNull(list, "results element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder assertResults(boolean assertResults) {
            this.assertResults = assertResults;
            this.optBits |= 4L;
            return this;
        }

        public final Builder operator(String operator) {
            this.operator = Objects.requireNonNull(operator, "operator");
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.database = null;
            this.query = null;
            if (this.resultColumns != null) {
                this.resultColumns.clear();
            }
            if (this.results != null) {
                this.results.clear();
            }
            this.assertResults = false;
            this.operator = null;
            return this;
        }

        public QueryExample build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryExample(this);
        }

        private boolean resultColumnsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean resultsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean assertResultsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build QueryExample, some of required attributes are not set " + attributes;
        }
    }
}

