/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.gds.utils.StringFormatting;

final class ProcedureNameExtractor {
    private static final Pattern PATTERN = Pattern.compile("(\\sgds\\.)(\\w+\\.)*(\\w+)");

    private ProcedureNameExtractor() {
    }

    public static String findProcedureName(String codeSnippet) {
        Matcher matcher = PATTERN.matcher(codeSnippet);
        boolean matchesFound = matcher.find();
        if (matchesFound) {
            return matcher.group().trim();
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No procedure names found in: \n%s", (Object[])new Object[]{codeSnippet}));
    }
}

