/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc.syntax;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.annotation.CustomProcedure;
import org.neo4j.gds.doc.syntax.ProcedureLookup;

@ParametersAreNonnullByDefault
@Generated(from="ProcedureLookup.ProcedureKey", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProcedureKey
implements ProcedureLookup.ProcedureKey {
    private final String name;
    private final CustomProcedure.Namespace namespace;

    private ImmutableProcedureKey(String name, CustomProcedure.Namespace namespace) {
        this.name = Objects.requireNonNull(name, "name");
        this.namespace = Objects.requireNonNull(namespace, "namespace");
    }

    private ImmutableProcedureKey(ImmutableProcedureKey original, String name, CustomProcedure.Namespace namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CustomProcedure.Namespace namespace() {
        return this.namespace;
    }

    public final ImmutableProcedureKey withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableProcedureKey(this, newValue, this.namespace);
    }

    public final ImmutableProcedureKey withNamespace(CustomProcedure.Namespace value) {
        CustomProcedure.Namespace newValue = Objects.requireNonNull(value, "namespace");
        if (this.namespace == newValue) {
            return this;
        }
        return new ImmutableProcedureKey(this, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcedureKey && this.equalTo(0, (ImmutableProcedureKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcedureKey another) {
        return this.name.equals(another.name) && this.namespace.equals((Object)another.namespace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.namespace.hashCode();
        return h;
    }

    public String toString() {
        return "ProcedureKey{name=" + this.name + ", namespace=" + this.namespace + "}";
    }

    public static ProcedureLookup.ProcedureKey of(String name, CustomProcedure.Namespace namespace) {
        return new ImmutableProcedureKey(name, namespace);
    }

    static ProcedureLookup.ProcedureKey copyOf(ProcedureLookup.ProcedureKey instance) {
        if (instance instanceof ImmutableProcedureKey) {
            return (ImmutableProcedureKey)instance;
        }
        return ImmutableProcedureKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProcedureLookup.ProcedureKey", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_NAMESPACE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private CustomProcedure.Namespace namespace;

        private Builder() {
        }

        public final Builder from(ImmutableProcedureKey instance) {
            return this.from((ProcedureLookup.ProcedureKey)instance);
        }

        final Builder from(ProcedureLookup.ProcedureKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.namespace(instance.namespace());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder namespace(CustomProcedure.Namespace namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.name = null;
            this.namespace = null;
            return this;
        }

        public ProcedureLookup.ProcedureKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcedureKey(null, this.name, this.namespace);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("namespace");
            }
            return "Cannot build ProcedureKey, some of required attributes are not set " + attributes;
        }
    }
}

