/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.doc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Treeprocessor;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.doc.ImmutableQueryExample;
import org.neo4j.gds.doc.QueryExample;
import org.neo4j.gds.doc.QueryExampleGroup;
import org.neo4j.gds.doc.syntax.DocQuery;
import org.neo4j.gds.utils.StringFormatting;

public class QueryCollectingTreeProcessor
extends Treeprocessor {
    private final List<DocQuery> beforeAllQueries = new ArrayList<DocQuery>();
    private final List<DocQuery> beforeEachQueries = new ArrayList<DocQuery>();
    private final Map<String, List<QueryExample>> queryExamples = new LinkedHashMap<String, List<QueryExample>>();

    public Document process(Document document) {
        this.collectBeforeAllQueries((StructuralNode)document);
        this.collectBeforeEachQueries((StructuralNode)document);
        this.collectQueryExamples((StructuralNode)document);
        return document;
    }

    public List<DocQuery> getBeforeAllQueries() {
        return this.beforeAllQueries;
    }

    public List<DocQuery> getBeforeEachQueries() {
        return this.beforeEachQueries;
    }

    public List<QueryExampleGroup> getQueryExampleGroups() {
        return this.queryExamples.entrySet().stream().map(e -> QueryExampleGroup.builder().displayName((String)e.getKey()).queryExamples((Iterable)e.getValue()).build()).collect(Collectors.toList());
    }

    private void collectBeforeAllQueries(StructuralNode document) {
        List<DocQuery> queries = QueryCollectingTreeProcessor.CollectSetupQueries(document, "setup-query");
        this.beforeAllQueries.addAll(queries);
    }

    private void collectBeforeEachQueries(StructuralNode document) {
        List<DocQuery> queries = QueryCollectingTreeProcessor.CollectSetupQueries(document, "graph-project-query");
        this.beforeEachQueries.addAll(queries);
    }

    private static List<DocQuery> CollectSetupQueries(StructuralNode node, String setupQueryType) {
        List nodes = node.findBy(Map.of("role", setupQueryType));
        return nodes.stream().map(QueryCollectingTreeProcessor::ParseDocQuery).collect(Collectors.toList());
    }

    private static DocQuery ParseDocQuery(StructuralNode structuralNode) {
        return DocQuery.builder().query(QueryCollectingTreeProcessor.parseQuery(structuralNode)).operator(QueryCollectingTreeProcessor.parseOperator(structuralNode)).build();
    }

    private static String parseOperator(StructuralNode structuralNode) {
        return structuralNode.getAttribute((Object)"operator", (Object)"").toString();
    }

    private void collectQueryExamples(StructuralNode node) {
        List examples = node.findBy(Map.of("role", "query-example"));
        for (StructuralNode example : examples) {
            String displayName = this.extractDisplayName(example);
            QueryExample queryExample = this.convertToQueryExample(example);
            this.addQueryExample(displayName, queryExample);
        }
    }

    private void addQueryExample(String displayName, QueryExample queryExample) {
        this.queryExamples.computeIfAbsent(displayName, key -> new ArrayList());
        this.queryExamples.get(displayName).add(queryExample);
    }

    private QueryExample convertToQueryExample(StructuralNode queryExampleNode) {
        StructuralNode codeBlock = this.findByContext(queryExampleNode, ":listing");
        String query = QueryCollectingTreeProcessor.parseQuery(codeBlock);
        ImmutableQueryExample.Builder queryExampleBuilder = QueryExample.builder().query(query);
        if (queryExampleNode.hasAttribute((Object)"operator")) {
            queryExampleBuilder.operator(queryExampleNode.getAttribute((Object)"operator").toString());
        }
        if (queryExampleNode.hasAttribute((Object)"database")) {
            queryExampleBuilder.database(queryExampleNode.getAttribute((Object)"database").toString());
        }
        if (Boolean.parseBoolean(queryExampleNode.getAttribute((Object)"no-result", (Object)false).toString())) {
            queryExampleBuilder.assertResults(false);
        } else {
            this.parseResultTable(queryExampleNode, queryExampleBuilder);
        }
        return queryExampleBuilder.build();
    }

    private void parseResultTable(StructuralNode queryExampleNode, ImmutableQueryExample.Builder queryExampleBuilder) {
        Table resultsTable = (Table)this.findByContext(queryExampleNode, ":table");
        List<String> resultColumns = ((Row)resultsTable.getHeader().get(0)).getCells().stream().map(Cell::getText).collect(Collectors.toList());
        queryExampleBuilder.resultColumns(resultColumns);
        List body = resultsTable.getBody();
        for (Row resultRow : body) {
            queryExampleBuilder.addResult(resultRow.getCells().stream().map(Cell::getText).map(QueryCollectingTreeProcessor::undoReplacements).collect(Collectors.toList()));
        }
    }

    @SuppressFBWarnings(value={"ITU_INAPPROPRIATE_TOSTRING_USE"})
    private String extractDisplayName(StructuralNode queryExample) {
        Object groupAttribute = queryExample.getAttribute((Object)"group");
        if (groupAttribute != null) {
            return groupAttribute.toString();
        }
        StructuralNode codeBlock = this.findByContext(queryExample, ":listing");
        if (codeBlock.getTitle() != null) {
            return codeBlock.getTitle();
        }
        return QueryCollectingTreeProcessor.parseQuery(codeBlock) + " - " + UUID.randomUUID().toString().substring(0, 5);
    }

    @NotNull
    private static String parseQuery(StructuralNode structuralNode) {
        return QueryCollectingTreeProcessor.undoReplacements(structuralNode.getContent().toString());
    }

    private StructuralNode findByContext(StructuralNode node, String context) {
        return (StructuralNode)node.findBy(Map.of("context", context)).stream().findFirst().orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No nodes found for context '%s'", (Object[])new Object[]{context})));
    }

    private static String undoReplacements(String content) {
        return content.replace("&gt;", ">").replace("&lt;", "<");
    }
}

